<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SGUESTGETV ServiceType
 * @subpackage Services
 */
class SGUESTGETV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_GUEST_GET_V001
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_GUEST_GET_V002](../S_GUEST_GET_V002) - Naming convention changes### GeneralThis service returns a specific guest.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GUEST_GET_V001Request $body
     * @return \StructType\S_GUEST_GET_V001Response|bool
     */
    public function S_GUEST_GET_V001(\StructType\S_GUEST_GET_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GUEST_GET_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_GUEST_GET_V002
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_GUEST_GET_V003](../S_GUEST_GET_V003) - Added language ISO 639-1, guest generic extensions (extra information) and newsletter subscription information### GeneralThis service
     * returns a specific guest.### Input- GUEST-OBJID: ObjID of the guest, which can be obtained from other defined services. Mandatory### OutputGuest data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GUEST_GET_V002Request $body
     * @return \StructType\S_GUEST_GET_V002Response|bool
     */
    public function S_GUEST_GET_V002(\StructType\S_GUEST_GET_V002Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GUEST_GET_V002($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_GUEST_GET_V003
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_GUEST_GET_V004](../S_GUEST_GET_V004) - Extended with discountgroup, emailfilter and loyalty card data### GeneralThis service returns a specific guest.### Input-
     * GUEST-OBJID: ObjID of the guest, which can be obtained from other defined services. Mandatory### OutputGuest data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GUEST_GET_V003Request $body
     * @return \StructType\S_GUEST_GET_V003Response|bool
     */
    public function S_GUEST_GET_V003(\StructType\S_GUEST_GET_V003Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GUEST_GET_V003($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_GUEST_GET_V004
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_GUEST_GET_V005](../S_GUEST_GET_V005) - Added documentnumber and documenttype fields### GeneralThis service returns a specific guest.### Input- GUEST-OBJID: ObjID of the
     * guest, which can be obtained from other defined services. Mandatory### OutputGuest data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GUEST_GET_V004Request $body
     * @return \StructType\S_GUEST_GET_V004Response|bool
     */
    public function S_GUEST_GET_V004(\StructType\S_GUEST_GET_V004Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GUEST_GET_V004($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_GUEST_GET_V005
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_GUEST_GET_V006](../S_GUEST_GET_V006) - Added iata, birthcountry, placeOfBirth and tax related fields### GeneralThis service returns a specific guest.### Input- GUEST-OBJID:
     * ObjID of the guest, which can be obtained from other defined services. Mandatory### OutputGuest data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GUEST_GET_V005Request $body
     * @return \StructType\S_GUEST_GET_V005Response|bool
     */
    public function S_GUEST_GET_V005(\StructType\S_GUEST_GET_V005Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GUEST_GET_V005($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_GUEST_GET_V006
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_GUEST_GET_V007](../S_GUEST_GET_V007) - Added mother company### GeneralThis service returns a specific guest.### Input- GUEST-OBJID: ObjID of the guest, which can be
     * obtained from other defined services. Mandatory### OutputGuest data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GUEST_GET_V006Request $body
     * @return \StructType\S_GUEST_GET_V006Response|bool
     */
    public function S_GUEST_GET_V006(\StructType\S_GUEST_GET_V006Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GUEST_GET_V006($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_GUEST_GET_V007
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_GUEST_GET_V008](../S_GUEST_GET_V008) - Added guest identification, vip, vip2 and comments. ### General This service returns a specific guest. ### Input - GUEST-OBJID: ObjID
     * of the guest, which can be obtained from other defined services. Mandatory ### Output Guest data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GUEST_GET_V007Request $body
     * @return \StructType\S_GUEST_GET_V007Response|bool
     */
    public function S_GUEST_GET_V007(\StructType\S_GUEST_GET_V007Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GUEST_GET_V007($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_GUEST_GET_V008
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service returns a specific guest.### Input- GUEST-OBJID: ObjID of the guest, which can be obtained from other defined services. Mandatory### OutputGuest data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GUEST_GET_V008Request $body
     * @return \StructType\S_GUEST_GET_V008Response|bool
     */
    public function S_GUEST_GET_V008(\StructType\S_GUEST_GET_V008Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GUEST_GET_V008($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_GUEST_GET_V001Response|\StructType\S_GUEST_GET_V002Response|\StructType\S_GUEST_GET_V003Response|\StructType\S_GUEST_GET_V004Response|\StructType\S_GUEST_GET_V005Response|\StructType\S_GUEST_GET_V006Response|\StructType\S_GUEST_GET_V007Response|\StructType\S_GUEST_GET_V008Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
