<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SGUESTCOMMENTGETV ServiceType
 * @subpackage Services
 */
class SGUESTCOMMENTGETV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_GUEST_COMMENT_GET_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service lists comments for a given guest.### Input- GUEST-OBJID: ObjID of the guest, which can be obtained from other defined servicesor- GUEST-CENTRALID: Central ID of the guest, which can be obtained from other
     * defined services### Output
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GUEST_COMMENT_GET_V001Request $body
     * @return \StructType\S_GUEST_COMMENT_GET_V001Response|bool
     */
    public function S_GUEST_COMMENT_GET_V001(\StructType\S_GUEST_COMMENT_GET_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GUEST_COMMENT_GET_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_GUEST_COMMENT_GET_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
