<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SGOHOTELV ServiceType
 * @subpackage Services
 */
class SGOHOTELV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_GO_HOTEL_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service returns detailed information of a specific hotel.### Input- HOTEL-OBJID: objID of the hotel### OutputHotel information plus first image containing the description 'SIHOT.GO', if it exists.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_GO_HOTEL_V001Request $body
     * @return \StructType\S_GO_HOTEL_V001Response|bool
     */
    public function S_GO_HOTEL_V001(\StructType\S_GO_HOTEL_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_GO_HOTEL_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_GO_HOTEL_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
