<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SEVENTRESERVATIONSERVICEADDV ServiceType
 * @subpackage Services
 */
class SEVENTRESERVATIONSERVICEADDV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * S_EVENT_RESERVATION_SERVICE_ADD_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service is able to add a service or a package to a particular event reservation or room reservation or module reservation. Also services to room reservations that are assigned to a module reservation can be added.###
     * InputDue to that the service/package can be added to different nodes in the event tree, the necessary data needs to be sent to address the targeted node for the request. Use the refroomresobjid for room reservations and refmoduleresobjid for module
     * reservations. If there are both empty, the service/package will be added to the event. If the room is below a module reservation, the refmoduleresobjid needs not to be sent. The room reservation is identifiable by its ObjID.HINT: The ObjID of the
     * event reservation is a precondition for everything and needs to be set in all cases. The service code is also required.With the service the fromDate, toDate and also the timeFrom or timeTo as well as the numberliteral can be set. The service will
     * create at least one data set per day between dateFrom and dateTo (inclusive). In case of assigning a package, there will be also one data set per entry in the components. If there are no data for the dates or times, the values of the superior node
     * will be overtaken (Room in case of room services, module in case of module services and so on).### OutputThe service will return all services (no matter if they are standalone or from a package) that are assigned to that event reservation.The data is
     * stored per date, and the result will contain all service entries from the event reservation, not only the recently created or assigned.The result contains among other things the ObjID of every assigned service. The ObjID is necessary to change or
     * remove the particular service afterwards.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_EVENT_RESERVATION_SERVICE_ADD_V001Request $body
     * @return \StructType\S_EVENT_RESERVATION_SERVICE_ADD_V001Response|bool
     */
    public function S_EVENT_RESERVATION_SERVICE_ADD_V001(\StructType\S_EVENT_RESERVATION_SERVICE_ADD_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_EVENT_RESERVATION_SERVICE_ADD_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_EVENT_RESERVATION_SERVICE_ADD_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
