<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SBENCHMARKV ServiceType
 * @subpackage Services
 */
class SBENCHMARKV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_BENCHMARK_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service returns benchmark data.### InputOnly the SecurityID must be specified.### OutputThe service provides information about the speed of database accesses, memory utilization, CPU utilization, etc.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_BENCHMARK_V001Request $body
     * @return \StructType\S_BENCHMARK_V001Response|bool
     */
    public function S_BENCHMARK_V001(\StructType\S_BENCHMARK_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_BENCHMARK_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_BENCHMARK_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
