<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SAUTHENTICATEV ServiceType
 * @subpackage Services
 */
class SAUTHENTICATEV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_AUTHENTICATE_V001
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_AUTHENTICATE_V002](../S_AUTHENTICATE_V002) - Added product field (input)### GeneralThis service performs an authentication. If the authentication is successful, a
     * securityID is returned and can be used to access all other available services.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_AUTHENTICATE_V001Request $body
     * @return \StructType\S_AUTHENTICATE_V001Response|bool
     */
    public function S_AUTHENTICATE_V001(\StructType\S_AUTHENTICATE_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_AUTHENTICATE_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_AUTHENTICATE_V002
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service performs an authentication. If the authentication is successful, a securityID is returned and can be used to access all other available services.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_AUTHENTICATE_V002Request $body
     * @return \StructType\S_AUTHENTICATE_V002Response|bool
     */
    public function S_AUTHENTICATE_V002(\StructType\S_AUTHENTICATE_V002Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_AUTHENTICATE_V002($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_AUTHENTICATE_V001Response|\StructType\S_AUTHENTICATE_V002Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
