<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SACTIVITYSEARCHV ServiceType
 * @subpackage Services
 */
class SACTIVITYSEARCHV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_ACTIVITY_SEARCH_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service delivers all activities according to the provided search criteria.### Input- hotels: hotels the activities/trails are in, field can be comma-separated for multiple selection- user: user id- trailType:
     * trailType from activity/trail. Have a look at the result of service S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Request.- activitytype: Compare to "Node1Type" in the result of service S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Request.- activitysubtype:
     * Compare to "Node2Type" in the result of service S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Request.- refobjid: ObjID of the referenced object (e.g. the ObjID of an event reservation).- datefrom: If element is missing, then it's initialized with the hotel
     * date. Send empty element for no validation.- dateto: If element is missing, then it's initialized with the hotel date. Send empty element for no validation.- onlyOpen: Searching for open activities only.### Output- ACTIVITY-OBJID: ObjID of the
     * activity- user: user id- status: combo box("ts") key value (can be defined in SIHOT)- description: description of the trail- appointmentdate: format: yyyy-mm-DD- time: format: hh:mm- endDate: format: yyyy-mm-DD- endTime: format: hh:mm- comment:
     * string comment - refobjid: ObjID of the referenced object
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ACTIVITY_SEARCH_V001Request $body
     * @return \StructType\S_ACTIVITY_SEARCH_V001Response|bool
     */
    public function S_ACTIVITY_SEARCH_V001(\StructType\S_ACTIVITY_SEARCH_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ACTIVITY_SEARCH_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named S_ACTIVITY_SEARCH_V002
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service delivers all activities according to the provided search criteria.### Input- hotels: hotels the activities/trails are in, field can be comma-separated for multiple selection- user: user id- trailType:
     * trailType from activity/trail. Have a look at the result of service S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Request.- activitytype: Compare to "Node1Type" in the result of service S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Request.- activitysubtype:
     * Compare to "Node2Type" in the result of service S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Request.- refobjid: ObjID of the referenced object (e.g. the ObjID of an event reservation).- datefrom: If element is missing, then it's initialized with the hotel
     * date. Send empty element for no validation.- dateto: If element is missing, then it's initialized with the hotel date. Send empty element for no validation.- onlyOpen: Searching for open activities only.### Output- ACTIVITY-OBJID: ObjID of the
     * activity- user: user id- status: combo box("ts") key value (can be defined in SIHOT)- description: description of the trail- appointmentdate: format: yyyy-mm-DD- time: format: hh:mm- endDate: format: yyyy-mm-DD- endTime: format: hh:mm- comment:
     * string comment - refobjid: ObjID of the referenced object- refTreeObjId: objID refTree - type: string type of the trail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ACTIVITY_SEARCH_V002Request $body
     * @return \StructType\S_ACTIVITY_SEARCH_V002Response|bool
     */
    public function S_ACTIVITY_SEARCH_V002(\StructType\S_ACTIVITY_SEARCH_V002Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ACTIVITY_SEARCH_V002($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_ACTIVITY_SEARCH_V001Response|\StructType\S_ACTIVITY_SEARCH_V002Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
