<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SACTIVITYADDV ServiceType
 * @subpackage Services
 */
class SACTIVITYADDV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_ACTIVITY_ADD_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service adds an activity to the trails.ATTENTION!You can add activities to any trail. SIHOT does not check if the activity is saved in the "correct" trail.Please ensure that you use the correct trail types, objIDs and
     * nodes for the intended purpose. This service does not create new nodes. Either use existing nodes or create new nodes in SIHOT.This service includes information found in:- S_EVENT_RESERVATION_TRAIL_NODE_GET_V001- S_GUEST_TRAIL_NODE_GET_V001 (for
     * trailType, Node1Type and Node2Type)- S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001 (for objIDs of event information, service reservation, module reservation, room reservation, equipment reservation)### Input- trailType: trail type e.g.: Event (54000),
     * Event Appointments(52000), Event Traces (53000), Guest profile (12000)- Node1Type: type e.g event reservation(VANA), service reservation(LST), module reservation (MOR), room reservation (RAR), guest profile activity (0005) or to add trail (0000)-
     * Node2Type: This node is responsible for creating a trail within a sub-trail.- refObjID: objID of base node, e.g. event reservation ObjID or guest profile ObjID- refTreeObjID:When adding the new activity to the event, use the same as in the refObjID.
     * - Otherwise use the objID of the parent tree node in which the activity should be created (e.g. objID of the module reservation to create an activity in this module reservation). - see service S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001-
     * parentRefObjID: Required for follow-up trails only (not related to the treeRefObjID!). ObjID of the master trail. - see service S_EVENT_RESERVATION_TRAIL_NODE_GET_V001/S_GUEST_TRAIL_NODE_GET_V001- description: Description of the activity- status:
     * combo box("ts") key value (can be defined in SIHOT)- beginDate: format: yyyy-mm-DD- beginTime: format: hh:mm- endDate: format: yyyy-mm-DD- endTime: format: hh:mm- user: SIHOT userID- comment: string comment### Output- ACTIVITY-OBJID: ObjID of the
     * newly created activity! If this field is empty or missing, the activity was not created (fail).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ACTIVITY_ADD_V001Request $body
     * @return \StructType\S_ACTIVITY_ADD_V001Response|bool
     */
    public function S_ACTIVITY_ADD_V001(\StructType\S_ACTIVITY_ADD_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ACTIVITY_ADD_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_ACTIVITY_ADD_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
