<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SACCOUNTSETTLEV ServiceType
 * @subpackage Services
 */
class SACCOUNTSETTLEV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_ACCOUNT_SETTLE_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service settles an account, if it is balanced### Input- ACCOUNT-OBJID: OBJID of the folio on which the payment should be posted- accountType: - x for guest - y for orderer### Output- INVOICE-OBJID: OBJID of the
     * invoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ACCOUNT_SETTLE_V001Request $body
     * @return \StructType\S_ACCOUNT_SETTLE_V001Response|bool
     */
    public function S_ACCOUNT_SETTLE_V001(\StructType\S_ACCOUNT_SETTLE_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ACCOUNT_SETTLE_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_ACCOUNT_SETTLE_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
