<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SACCOUNTINACTIVATEV ServiceType
 * @subpackage Services
 */
class SACCOUNTINACTIVATEV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named S_ACCOUNT_INACTIVATE_V001
     * Meta information extracted from the WSDL
     * - documentation: ### GeneralThis service inactivates an account if its balance is zero and everything is settled.### Input- ACCOUNT-OBJID: ObjID of the account, which can be obtained from other defined services. Mandatory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\S_ACCOUNT_INACTIVATE_V001Request $body
     * @return \StructType\S_ACCOUNT_INACTIVATE_V001Response|bool
     */
    public function S_ACCOUNT_INACTIVATE_V001(\StructType\S_ACCOUNT_INACTIVATE_V001Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->S_ACCOUNT_INACTIVATE_V001($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\S_ACCOUNT_INACTIVATE_V001Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
