<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetCategoryMapping
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_CATEGORY_MAPPING_GET_V001](../S_CATEGORY_MAPPING_GET_V001) - Replaced due to naming convention
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCategoryMappingRequest $body
     * @return \StructType\GetCategoryMappingResponse|bool
     */
    public function GetCategoryMapping(\StructType\GetCategoryMappingRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCategoryMapping($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPackageMapping
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_PACKAGE_MAPPING_GET_V001](../S_PACKAGE_MAPPING_GET_V001) - Replaced due to naming convention
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPackageMappingRequest $body
     * @return \StructType\GetPackageMappingResponse|bool
     */
    public function GetPackageMapping(\StructType\GetPackageMappingRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPackageMapping($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetServiceMapping
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_SERVICE_MAPPING_GET_V001](../S_SERVICE_MAPPING_GET_V001) - Replaced due to naming convention
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetServiceMappingRequest $body
     * @return \StructType\GetServiceMappingResponse|bool
     */
    public function GetServiceMapping(\StructType\GetServiceMappingRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->GetServiceMapping($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetCategoryMappingResponse|\StructType\GetPackageMappingResponse|\StructType\GetServiceMappingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
