<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GIFTVOUCHERSELLV ServiceType
 * @subpackage Services
 */
class GIFTVOUCHERSELLV extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GIFT_VOUCHER_SELL_V01
     * Meta information extracted from the WSDL
     * - documentation: ### DeprecatedThis has been deprecated. Please refer to:- [S_GIFT_VOUCHER_SELL_V001](../S_GIFT_VOUCHER_SELL_V001) - Replaced due to naming convention### GeneralThis service performs a gift voucher sale.### Input - guestObjID: unique
     * id of a guest- serviceCode: service code- amount: amount of the gift voucher- typeOfPayment: type of payment### Output- objid: unique id- status: - 1 = valid - 2 = not valid - 3 = redeemed - 4 = invoiced - 5 = suspended - 6 = incomplete - 7 =
     * unavailable- number, externalReference- amount- sellDate, hotelSell, expiryDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GIFT_VOUCHER_SELL_V01Request $body
     * @return \StructType\GIFT_VOUCHER_SELL_V01Response|bool
     */
    public function GIFT_VOUCHER_SELL_V01(\StructType\GIFT_VOUCHER_SELL_V01Request $body)
    {
        try {
            $this->setResult($this->getSoapClient()->GIFT_VOUCHER_SELL_V01($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GIFT_VOUCHER_SELL_V01Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
