<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Handle ServiceType
 * @subpackage Services
 */
class Handle extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named HandleRequest_UI
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $strRequestXML
     * @return string|bool
     */
    public function HandleRequest_UI($strRequestXML)
    {
        try {
            $this->setResult($this->getSoapClient()->HandleRequest_UI($strRequestXML));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HandleRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $strRequestXML
     * @return string|bool
     */
    public function HandleRequest($strRequestXML)
    {
        try {
            $this->setResult($this->getSoapClient()->HandleRequest($strRequestXML));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
