<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Seek ServiceType
 */
$seek = new \ServiceType\Seek($options);
/**
 * Sample call for seekProduct operation/method
 */
if ($seek->seekProduct($seekProductRequestType) !== false) {
    print_r($seek->getResult());
} else {
    print_r($seek->getLastError());
}
/**
 * Sample call for seekProductVersions operation/method
 */
if ($seek->seekProductVersions($seekProductVersionsRequestType) !== false) {
    print_r($seek->getResult());
} else {
    print_r($seek->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getProduct operation/method
 */
if ($get->getProduct($getProductRequestType) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProductVersions operation/method
 */
if ($get->getProductVersions($getProductVersionsRequestType) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProductList operation/method
 */
if ($get->getProductList($getProductListRequestType) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProductVersionsList operation/method
 */
if ($get->getProductVersionsList($getProductVersionsListRequestType) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getChangedProductVersionsList operation/method
 */
if ($get->getChangedProductVersionsList($getChangedProductVersionsListRequestType) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCatalog operation/method
 */
if ($get->getCatalog($getCatalogRequestType) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCatalogList operation/method
 */
if ($get->getCatalogList($getCatalogListRequestType) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProductChangeInformation operation/method
 */
if ($get->getProductChangeInformation($getProductChangeInformationRequestType) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCatalogChangeInformation operation/method
 */
if ($get->getCatalogChangeInformation($getCatalogChangeInformationRequestType) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Register ServiceType
 */
$register = new \ServiceType\Register($options);
/**
 * Sample call for registerEMailAdress operation/method
 */
if ($register->registerEMailAdress($registerEMailAdressRequestType) !== false) {
    print_r($register->getResult());
} else {
    print_r($register->getLastError());
}
/**
 * Sample call for registerNotification operation/method
 */
if ($register->registerNotification($registerNotificationRequestType) !== false) {
    print_r($register->getResult());
} else {
    print_r($register->getLastError());
}
