<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Seek ServiceType
 * @subpackage Services
 */
class Seek extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named seekProduct
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param seekProductRequestType $seekProductRequestType
     * @return seekProductResponse|bool
     */
    public function seekProduct($seekProductRequestType)
    {
        try {
            $this->setResult(self::getSoapClient()->seekProduct($seekProductRequestType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named seekProductVersions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param seekProductVersionsRequestType $seekProductVersionsRequestType
     * @return seekProductVersionsResponse|bool
     */
    public function seekProductVersions($seekProductVersionsRequestType)
    {
        try {
            $this->setResult(self::getSoapClient()->seekProductVersions($seekProductVersionsRequestType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return seekProductResponse|seekProductVersionsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
