<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getProduct
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getProductRequestType $getProductRequestType
     * @return getProductResponse|bool
     */
    public function getProduct($getProductRequestType)
    {
        try {
            $this->setResult(self::getSoapClient()->getProduct($getProductRequestType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductVersions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getProductVersionsRequestType $getProductVersionsRequestType
     * @return getProductVersionsResponse|bool
     */
    public function getProductVersions($getProductVersionsRequestType)
    {
        try {
            $this->setResult(self::getSoapClient()->getProductVersions($getProductVersionsRequestType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getProductListRequestType $getProductListRequestType
     * @return getProductListResponse|bool
     */
    public function getProductList($getProductListRequestType)
    {
        try {
            $this->setResult(self::getSoapClient()->getProductList($getProductListRequestType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductVersionsList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getProductVersionsListRequestType $getProductVersionsListRequestType
     * @return getProductVersionsListResponse|bool
     */
    public function getProductVersionsList($getProductVersionsListRequestType)
    {
        try {
            $this->setResult(self::getSoapClient()->getProductVersionsList($getProductVersionsListRequestType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getChangedProductVersionsList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getChangedProductVersionsListRequestType $getChangedProductVersionsListRequestType
     * @return getChangedProductVersionsListResponse|bool
     */
    public function getChangedProductVersionsList($getChangedProductVersionsListRequestType)
    {
        try {
            $this->setResult(self::getSoapClient()->getChangedProductVersionsList($getChangedProductVersionsListRequestType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCatalog
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getCatalogRequestType $getCatalogRequestType
     * @return getCatalogResponse|bool
     */
    public function getCatalog($getCatalogRequestType)
    {
        try {
            $this->setResult(self::getSoapClient()->getCatalog($getCatalogRequestType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCatalogList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getCatalogListRequestType $getCatalogListRequestType
     * @return getCatalogListResponse|bool
     */
    public function getCatalogList($getCatalogListRequestType)
    {
        try {
            $this->setResult(self::getSoapClient()->getCatalogList($getCatalogListRequestType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductChangeInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getProductChangeInformationRequestType $getProductChangeInformationRequestType
     * @return getProductChangeInformationResponse|bool
     */
    public function getProductChangeInformation($getProductChangeInformationRequestType)
    {
        try {
            $this->setResult(self::getSoapClient()->getProductChangeInformation($getProductChangeInformationRequestType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCatalogChangeInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getCatalogChangeInformationRequestType $getCatalogChangeInformationRequestType
     * @return getCatalogChangeInformationResponse|bool
     */
    public function getCatalogChangeInformation($getCatalogChangeInformationRequestType)
    {
        try {
            $this->setResult(self::getSoapClient()->getCatalogChangeInformation($getCatalogChangeInformationRequestType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return getCatalogChangeInformationResponse|getCatalogListResponse|getCatalogResponse|getChangedProductVersionsListResponse|getProductChangeInformationResponse|getProductListResponse|getProductResponse|getProductVersionsListResponse|getProductVersionsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
