<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Register ServiceType
 * @subpackage Services
 */
class Register extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named registerEMailAdress
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param registerEMailAdressRequestType $registerEMailAdressRequestType
     * @return registerEMailAdressResponse|bool
     */
    public function registerEMailAdress($registerEMailAdressRequestType)
    {
        try {
            $this->setResult(self::getSoapClient()->registerEMailAdress($registerEMailAdressRequestType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named registerNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param registerNotificationRequestType $registerNotificationRequestType
     * @return registerNotificationResponse|bool
     */
    public function registerNotification($registerNotificationRequestType)
    {
        try {
            $this->setResult(self::getSoapClient()->registerNotification($registerNotificationRequestType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return registerEMailAdressResponse|registerNotificationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
