<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Response
 * @subpackage Structs
 */
class Response extends AbstractStructBase
{
    /**
     * The Successfull
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Successfull;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * Constructor method for Response
     * @uses Response::setSuccessfull()
     * @uses Response::setMessage()
     * @param bool $successfull
     * @param string $message
     */
    public function __construct($successfull = null, $message = null)
    {
        $this
            ->setSuccessfull($successfull)
            ->setMessage($message);
    }
    /**
     * Get Successfull value
     * @return bool|null
     */
    public function getSuccessfull()
    {
        return $this->Successfull;
    }
    /**
     * Set Successfull value
     * @param bool $successfull
     * @return \StructType\Response
     */
    public function setSuccessfull($successfull = null)
    {
        // validation for constraint: boolean
        if (!is_null($successfull) && !is_bool($successfull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successfull, true), gettype($successfull)), __LINE__);
        }
        $this->Successfull = $successfull;
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \StructType\Response
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
}
