<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetAgentDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAgentDetail $parameters
     * @return \StructType\GetAgentDetailResponse|bool
     */
    public function GetAgentDetail(\StructType\GetAgentDetail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAgentDetail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAgentLeads
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAgentLeads $parameters
     * @return \StructType\GetAgentLeadsResponse|bool
     */
    public function GetAgentLeads(\StructType\GetAgentLeads $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAgentLeads($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLeadDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLeadDetail $parameters
     * @return \StructType\GetLeadDetailResponse|bool
     */
    public function GetLeadDetail(\StructType\GetLeadDetail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLeadDetail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAgentLeadsSinceDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAgentLeadsSinceDate $parameters
     * @return \StructType\GetAgentLeadsSinceDateResponse|bool
     */
    public function GetAgentLeadsSinceDate(\StructType\GetAgentLeadsSinceDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAgentLeadsSinceDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAgentApplicationsSinceDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAgentApplicationsSinceDate $parameters
     * @return \StructType\GetAgentApplicationsSinceDateResponse|bool
     */
    public function GetAgentApplicationsSinceDate(\StructType\GetAgentApplicationsSinceDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAgentApplicationsSinceDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetAgentApplicationsSinceLast30Days
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAgentApplicationsSinceLast30Days $parameters
     * @return \StructType\GetAgentApplicationsSinceLast30DaysResponse|bool
     */
    public function GetAgentApplicationsSinceLast30Days(\StructType\GetAgentApplicationsSinceLast30Days $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAgentApplicationsSinceLast30Days($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetApplication
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetApplication $parameters
     * @return \StructType\GetApplicationResponse|bool
     */
    public function GetApplication(\StructType\GetApplication $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetApplication($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetApplicationsCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetApplicationsCount $parameters
     * @return \StructType\GetApplicationsCountResponse|bool
     */
    public function GetApplicationsCount(\StructType\GetApplicationsCount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetApplicationsCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPolicyType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPolicyType $parameters
     * @return \StructType\GetPolicyTypeResponse|bool
     */
    public function GetPolicyType(\StructType\GetPolicyType $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPolicyType($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAgentApplicationsSinceDateResponse|\StructType\GetAgentApplicationsSinceLast30DaysResponse|\StructType\GetAgentDetailResponse|\StructType\GetAgentLeadsResponse|\StructType\GetAgentLeadsSinceDateResponse|\StructType\GetApplicationResponse|\StructType\GetApplicationsCountResponse|\StructType\GetLeadDetailResponse|\StructType\GetPolicyTypeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
