<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PopupData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PopupData
 * @subpackage Structs
 */
class PopupData extends AbstractStructBase
{
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The values
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $values;
    /**
     * Constructor method for PopupData
     * @uses PopupData::setMessage()
     * @uses PopupData::setValues()
     * @param string $message
     * @param \ArrayType\ArrayOfstring $values
     */
    public function __construct($message = null, \ArrayType\ArrayOfstring $values = null)
    {
        $this
            ->setMessage($message)
            ->setValues($values);
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \StructType\PopupData
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get values value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getValues()
    {
        return isset($this->values) ? $this->values : null;
    }
    /**
     * Set values value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $values
     * @return \StructType\PopupData
     */
    public function setValues(\ArrayType\ArrayOfstring $values = null)
    {
        if (is_null($values) || (is_array($values) && empty($values))) {
            unset($this->values);
        } else {
            $this->values = $values;
        }
        return $this;
    }
}
