<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetResponse
 * @subpackage Structs
 */
class GetResponse extends AbstractStructBase
{
    /**
     * The response
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Response
     */
    public $response;
    /**
     * The agentInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AgentInfo
     */
    public $agentInfo;
    /**
     * Constructor method for GetResponse
     * @uses GetResponse::setResponse()
     * @uses GetResponse::setAgentInfo()
     * @param \StructType\Response $response
     * @param \StructType\AgentInfo $agentInfo
     */
    public function __construct(\StructType\Response $response = null, \StructType\AgentInfo $agentInfo = null)
    {
        $this
            ->setResponse($response)
            ->setAgentInfo($agentInfo);
    }
    /**
     * Get response value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Response|null
     */
    public function getResponse()
    {
        return isset($this->response) ? $this->response : null;
    }
    /**
     * Set response value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Response $response
     * @return \StructType\GetResponse
     */
    public function setResponse(\StructType\Response $response = null)
    {
        if (is_null($response) || (is_array($response) && empty($response))) {
            unset($this->response);
        } else {
            $this->response = $response;
        }
        return $this;
    }
    /**
     * Get agentInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AgentInfo|null
     */
    public function getAgentInfo()
    {
        return isset($this->agentInfo) ? $this->agentInfo : null;
    }
    /**
     * Set agentInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AgentInfo $agentInfo
     * @return \StructType\GetResponse
     */
    public function setAgentInfo(\StructType\AgentInfo $agentInfo = null)
    {
        if (is_null($agentInfo) || (is_array($agentInfo) && empty($agentInfo))) {
            unset($this->agentInfo);
        } else {
            $this->agentInfo = $agentInfo;
        }
        return $this;
    }
}
