<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateApplicationTaken StructType
 * @subpackage Structs
 */
class CreateApplicationTaken extends AbstractStructBase
{
    /**
     * The CID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CID;
    /**
     * The AuthKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthKey;
    /**
     * The lead
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ApplicationData
     */
    public $lead;
    /**
     * Constructor method for CreateApplicationTaken
     * @uses CreateApplicationTaken::setCID()
     * @uses CreateApplicationTaken::setAuthKey()
     * @uses CreateApplicationTaken::setLead()
     * @param string $cID
     * @param string $authKey
     * @param \StructType\ApplicationData $lead
     */
    public function __construct($cID = null, $authKey = null, \StructType\ApplicationData $lead = null)
    {
        $this
            ->setCID($cID)
            ->setAuthKey($authKey)
            ->setLead($lead);
    }
    /**
     * Get CID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCID()
    {
        return isset($this->CID) ? $this->CID : null;
    }
    /**
     * Set CID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cID
     * @return \StructType\CreateApplicationTaken
     */
    public function setCID($cID = null)
    {
        // validation for constraint: string
        if (!is_null($cID) && !is_string($cID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cID, true), gettype($cID)), __LINE__);
        }
        if (is_null($cID) || (is_array($cID) && empty($cID))) {
            unset($this->CID);
        } else {
            $this->CID = $cID;
        }
        return $this;
    }
    /**
     * Get AuthKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthKey()
    {
        return isset($this->AuthKey) ? $this->AuthKey : null;
    }
    /**
     * Set AuthKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authKey
     * @return \StructType\CreateApplicationTaken
     */
    public function setAuthKey($authKey = null)
    {
        // validation for constraint: string
        if (!is_null($authKey) && !is_string($authKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authKey, true), gettype($authKey)), __LINE__);
        }
        if (is_null($authKey) || (is_array($authKey) && empty($authKey))) {
            unset($this->AuthKey);
        } else {
            $this->AuthKey = $authKey;
        }
        return $this;
    }
    /**
     * Get lead value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ApplicationData|null
     */
    public function getLead()
    {
        return isset($this->lead) ? $this->lead : null;
    }
    /**
     * Set lead value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ApplicationData $lead
     * @return \StructType\CreateApplicationTaken
     */
    public function setLead(\StructType\ApplicationData $lead = null)
    {
        if (is_null($lead) || (is_array($lead) && empty($lead))) {
            unset($this->lead);
        } else {
            $this->lead = $lead;
        }
        return $this;
    }
}
