<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ApplicationData
 * @subpackage Structs
 */
class ApplicationData extends AbstractStructBase
{
    /**
     * The AgentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgentID;
    /**
     * The AccountType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountType;
    /**
     * The LeadCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LeadCode;
    /**
     * The ApplicationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ApplicationDate;
    /**
     * The SubmittedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SubmittedDate;
    /**
     * The ApplicantFirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicantFirstName;
    /**
     * The ApplicantLastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicantLastName;
    /**
     * The EmailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailAddress;
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Carrier;
    /**
     * The Policy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Policy;
    /**
     * The SimplifiedUW
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SimplifiedUW;
    /**
     * The FaceAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FaceAmount;
    /**
     * The ModalType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModalType;
    /**
     * The ModalPremium
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ModalPremium;
    /**
     * The PaymentMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMode;
    /**
     * The PurchasedToProtect
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PurchasedToProtect;
    /**
     * The FirstTimeCarrier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $FirstTimeCarrier;
    /**
     * The SaleType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaleType;
    /**
     * Constructor method for ApplicationData
     * @uses ApplicationData::setAgentID()
     * @uses ApplicationData::setAccountType()
     * @uses ApplicationData::setLeadCode()
     * @uses ApplicationData::setApplicationDate()
     * @uses ApplicationData::setSubmittedDate()
     * @uses ApplicationData::setApplicantFirstName()
     * @uses ApplicationData::setApplicantLastName()
     * @uses ApplicationData::setEmailAddress()
     * @uses ApplicationData::setCarrier()
     * @uses ApplicationData::setPolicy()
     * @uses ApplicationData::setSimplifiedUW()
     * @uses ApplicationData::setFaceAmount()
     * @uses ApplicationData::setModalType()
     * @uses ApplicationData::setModalPremium()
     * @uses ApplicationData::setPaymentMode()
     * @uses ApplicationData::setPurchasedToProtect()
     * @uses ApplicationData::setFirstTimeCarrier()
     * @uses ApplicationData::setSaleType()
     * @param string $agentID
     * @param string $accountType
     * @param string $leadCode
     * @param string $applicationDate
     * @param string $submittedDate
     * @param string $applicantFirstName
     * @param string $applicantLastName
     * @param string $emailAddress
     * @param string $carrier
     * @param string $policy
     * @param bool $simplifiedUW
     * @param float $faceAmount
     * @param string $modalType
     * @param float $modalPremium
     * @param string $paymentMode
     * @param bool $purchasedToProtect
     * @param bool $firstTimeCarrier
     * @param string $saleType
     */
    public function __construct($agentID = null, $accountType = null, $leadCode = null, $applicationDate = null, $submittedDate = null, $applicantFirstName = null, $applicantLastName = null, $emailAddress = null, $carrier = null, $policy = null, $simplifiedUW = null, $faceAmount = null, $modalType = null, $modalPremium = null, $paymentMode = null, $purchasedToProtect = null, $firstTimeCarrier = null, $saleType = null)
    {
        $this
            ->setAgentID($agentID)
            ->setAccountType($accountType)
            ->setLeadCode($leadCode)
            ->setApplicationDate($applicationDate)
            ->setSubmittedDate($submittedDate)
            ->setApplicantFirstName($applicantFirstName)
            ->setApplicantLastName($applicantLastName)
            ->setEmailAddress($emailAddress)
            ->setCarrier($carrier)
            ->setPolicy($policy)
            ->setSimplifiedUW($simplifiedUW)
            ->setFaceAmount($faceAmount)
            ->setModalType($modalType)
            ->setModalPremium($modalPremium)
            ->setPaymentMode($paymentMode)
            ->setPurchasedToProtect($purchasedToProtect)
            ->setFirstTimeCarrier($firstTimeCarrier)
            ->setSaleType($saleType);
    }
    /**
     * Get AgentID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgentID()
    {
        return isset($this->AgentID) ? $this->AgentID : null;
    }
    /**
     * Set AgentID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agentID
     * @return \StructType\ApplicationData
     */
    public function setAgentID($agentID = null)
    {
        // validation for constraint: string
        if (!is_null($agentID) && !is_string($agentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentID, true), gettype($agentID)), __LINE__);
        }
        if (is_null($agentID) || (is_array($agentID) && empty($agentID))) {
            unset($this->AgentID);
        } else {
            $this->AgentID = $agentID;
        }
        return $this;
    }
    /**
     * Get AccountType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountType()
    {
        return isset($this->AccountType) ? $this->AccountType : null;
    }
    /**
     * Set AccountType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountType
     * @return \StructType\ApplicationData
     */
    public function setAccountType($accountType = null)
    {
        // validation for constraint: string
        if (!is_null($accountType) && !is_string($accountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountType, true), gettype($accountType)), __LINE__);
        }
        if (is_null($accountType) || (is_array($accountType) && empty($accountType))) {
            unset($this->AccountType);
        } else {
            $this->AccountType = $accountType;
        }
        return $this;
    }
    /**
     * Get LeadCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeadCode()
    {
        return isset($this->LeadCode) ? $this->LeadCode : null;
    }
    /**
     * Set LeadCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leadCode
     * @return \StructType\ApplicationData
     */
    public function setLeadCode($leadCode = null)
    {
        // validation for constraint: string
        if (!is_null($leadCode) && !is_string($leadCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadCode, true), gettype($leadCode)), __LINE__);
        }
        if (is_null($leadCode) || (is_array($leadCode) && empty($leadCode))) {
            unset($this->LeadCode);
        } else {
            $this->LeadCode = $leadCode;
        }
        return $this;
    }
    /**
     * Get ApplicationDate value
     * @return string|null
     */
    public function getApplicationDate()
    {
        return $this->ApplicationDate;
    }
    /**
     * Set ApplicationDate value
     * @param string $applicationDate
     * @return \StructType\ApplicationData
     */
    public function setApplicationDate($applicationDate = null)
    {
        // validation for constraint: string
        if (!is_null($applicationDate) && !is_string($applicationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationDate, true), gettype($applicationDate)), __LINE__);
        }
        $this->ApplicationDate = $applicationDate;
        return $this;
    }
    /**
     * Get SubmittedDate value
     * @return string|null
     */
    public function getSubmittedDate()
    {
        return $this->SubmittedDate;
    }
    /**
     * Set SubmittedDate value
     * @param string $submittedDate
     * @return \StructType\ApplicationData
     */
    public function setSubmittedDate($submittedDate = null)
    {
        // validation for constraint: string
        if (!is_null($submittedDate) && !is_string($submittedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($submittedDate, true), gettype($submittedDate)), __LINE__);
        }
        $this->SubmittedDate = $submittedDate;
        return $this;
    }
    /**
     * Get ApplicantFirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicantFirstName()
    {
        return isset($this->ApplicantFirstName) ? $this->ApplicantFirstName : null;
    }
    /**
     * Set ApplicantFirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicantFirstName
     * @return \StructType\ApplicationData
     */
    public function setApplicantFirstName($applicantFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($applicantFirstName) && !is_string($applicantFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicantFirstName, true), gettype($applicantFirstName)), __LINE__);
        }
        if (is_null($applicantFirstName) || (is_array($applicantFirstName) && empty($applicantFirstName))) {
            unset($this->ApplicantFirstName);
        } else {
            $this->ApplicantFirstName = $applicantFirstName;
        }
        return $this;
    }
    /**
     * Get ApplicantLastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicantLastName()
    {
        return isset($this->ApplicantLastName) ? $this->ApplicantLastName : null;
    }
    /**
     * Set ApplicantLastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicantLastName
     * @return \StructType\ApplicationData
     */
    public function setApplicantLastName($applicantLastName = null)
    {
        // validation for constraint: string
        if (!is_null($applicantLastName) && !is_string($applicantLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicantLastName, true), gettype($applicantLastName)), __LINE__);
        }
        if (is_null($applicantLastName) || (is_array($applicantLastName) && empty($applicantLastName))) {
            unset($this->ApplicantLastName);
        } else {
            $this->ApplicantLastName = $applicantLastName;
        }
        return $this;
    }
    /**
     * Get EmailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailAddress()
    {
        return isset($this->EmailAddress) ? $this->EmailAddress : null;
    }
    /**
     * Set EmailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailAddress
     * @return \StructType\ApplicationData
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        if (is_null($emailAddress) || (is_array($emailAddress) && empty($emailAddress))) {
            unset($this->EmailAddress);
        } else {
            $this->EmailAddress = $emailAddress;
        }
        return $this;
    }
    /**
     * Get Carrier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCarrier()
    {
        return isset($this->Carrier) ? $this->Carrier : null;
    }
    /**
     * Set Carrier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $carrier
     * @return \StructType\ApplicationData
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: string
        if (!is_null($carrier) && !is_string($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier, true), gettype($carrier)), __LINE__);
        }
        if (is_null($carrier) || (is_array($carrier) && empty($carrier))) {
            unset($this->Carrier);
        } else {
            $this->Carrier = $carrier;
        }
        return $this;
    }
    /**
     * Get Policy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPolicy()
    {
        return isset($this->Policy) ? $this->Policy : null;
    }
    /**
     * Set Policy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $policy
     * @return \StructType\ApplicationData
     */
    public function setPolicy($policy = null)
    {
        // validation for constraint: string
        if (!is_null($policy) && !is_string($policy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policy, true), gettype($policy)), __LINE__);
        }
        if (is_null($policy) || (is_array($policy) && empty($policy))) {
            unset($this->Policy);
        } else {
            $this->Policy = $policy;
        }
        return $this;
    }
    /**
     * Get SimplifiedUW value
     * @return bool|null
     */
    public function getSimplifiedUW()
    {
        return $this->SimplifiedUW;
    }
    /**
     * Set SimplifiedUW value
     * @param bool $simplifiedUW
     * @return \StructType\ApplicationData
     */
    public function setSimplifiedUW($simplifiedUW = null)
    {
        // validation for constraint: boolean
        if (!is_null($simplifiedUW) && !is_bool($simplifiedUW)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($simplifiedUW, true), gettype($simplifiedUW)), __LINE__);
        }
        $this->SimplifiedUW = $simplifiedUW;
        return $this;
    }
    /**
     * Get FaceAmount value
     * @return float|null
     */
    public function getFaceAmount()
    {
        return $this->FaceAmount;
    }
    /**
     * Set FaceAmount value
     * @param float $faceAmount
     * @return \StructType\ApplicationData
     */
    public function setFaceAmount($faceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($faceAmount) && !(is_float($faceAmount) || is_numeric($faceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($faceAmount, true), gettype($faceAmount)), __LINE__);
        }
        $this->FaceAmount = $faceAmount;
        return $this;
    }
    /**
     * Get ModalType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModalType()
    {
        return isset($this->ModalType) ? $this->ModalType : null;
    }
    /**
     * Set ModalType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modalType
     * @return \StructType\ApplicationData
     */
    public function setModalType($modalType = null)
    {
        // validation for constraint: string
        if (!is_null($modalType) && !is_string($modalType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modalType, true), gettype($modalType)), __LINE__);
        }
        if (is_null($modalType) || (is_array($modalType) && empty($modalType))) {
            unset($this->ModalType);
        } else {
            $this->ModalType = $modalType;
        }
        return $this;
    }
    /**
     * Get ModalPremium value
     * @return float|null
     */
    public function getModalPremium()
    {
        return $this->ModalPremium;
    }
    /**
     * Set ModalPremium value
     * @param float $modalPremium
     * @return \StructType\ApplicationData
     */
    public function setModalPremium($modalPremium = null)
    {
        // validation for constraint: float
        if (!is_null($modalPremium) && !(is_float($modalPremium) || is_numeric($modalPremium))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($modalPremium, true), gettype($modalPremium)), __LINE__);
        }
        $this->ModalPremium = $modalPremium;
        return $this;
    }
    /**
     * Get PaymentMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMode()
    {
        return isset($this->PaymentMode) ? $this->PaymentMode : null;
    }
    /**
     * Set PaymentMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMode
     * @return \StructType\ApplicationData
     */
    public function setPaymentMode($paymentMode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMode) && !is_string($paymentMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMode, true), gettype($paymentMode)), __LINE__);
        }
        if (is_null($paymentMode) || (is_array($paymentMode) && empty($paymentMode))) {
            unset($this->PaymentMode);
        } else {
            $this->PaymentMode = $paymentMode;
        }
        return $this;
    }
    /**
     * Get PurchasedToProtect value
     * @return bool|null
     */
    public function getPurchasedToProtect()
    {
        return $this->PurchasedToProtect;
    }
    /**
     * Set PurchasedToProtect value
     * @param bool $purchasedToProtect
     * @return \StructType\ApplicationData
     */
    public function setPurchasedToProtect($purchasedToProtect = null)
    {
        // validation for constraint: boolean
        if (!is_null($purchasedToProtect) && !is_bool($purchasedToProtect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($purchasedToProtect, true), gettype($purchasedToProtect)), __LINE__);
        }
        $this->PurchasedToProtect = $purchasedToProtect;
        return $this;
    }
    /**
     * Get FirstTimeCarrier value
     * @return bool|null
     */
    public function getFirstTimeCarrier()
    {
        return $this->FirstTimeCarrier;
    }
    /**
     * Set FirstTimeCarrier value
     * @param bool $firstTimeCarrier
     * @return \StructType\ApplicationData
     */
    public function setFirstTimeCarrier($firstTimeCarrier = null)
    {
        // validation for constraint: boolean
        if (!is_null($firstTimeCarrier) && !is_bool($firstTimeCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($firstTimeCarrier, true), gettype($firstTimeCarrier)), __LINE__);
        }
        $this->FirstTimeCarrier = $firstTimeCarrier;
        return $this;
    }
    /**
     * Get SaleType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleType()
    {
        return isset($this->SaleType) ? $this->SaleType : null;
    }
    /**
     * Set SaleType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleType
     * @return \StructType\ApplicationData
     */
    public function setSaleType($saleType = null)
    {
        // validation for constraint: string
        if (!is_null($saleType) && !is_string($saleType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleType, true), gettype($saleType)), __LINE__);
        }
        if (is_null($saleType) || (is_array($saleType) && empty($saleType))) {
            unset($this->SaleType);
        } else {
            $this->SaleType = $saleType;
        }
        return $this;
    }
}
