<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateAgent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateAgent $parameters
     * @return \StructType\UpdateAgentResponse|bool
     */
    public function UpdateAgent(\StructType\UpdateAgent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateAgent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateAgentLevelUpline
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateAgentLevelUpline $parameters
     * @return \StructType\UpdateAgentLevelUplineResponse|bool
     */
    public function UpdateAgentLevelUpline(\StructType\UpdateAgentLevelUpline $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateAgentLevelUpline($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateLead
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateLead $parameters
     * @return \StructType\UpdateLeadResponse|bool
     */
    public function UpdateLead(\StructType\UpdateLead $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateLead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateAgentAllowToOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateAgentAllowToOrder $parameters
     * @return \StructType\UpdateAgentAllowToOrderResponse|bool
     */
    public function UpdateAgentAllowToOrder(\StructType\UpdateAgentAllowToOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateAgentAllowToOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateAgentAllowToOrderResponse|\StructType\UpdateAgentLevelUplineResponse|\StructType\UpdateAgentResponse|\StructType\UpdateLeadResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
