<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationCreated StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ApplicationCreated
 * @subpackage Structs
 */
class ApplicationCreated extends AbstractStructBase
{
    /**
     * The Successfull
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Successfull;
    /**
     * The AgentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgentID;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Category;
    /**
     * The ApplicationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationCode;
    /**
     * The ApplicationTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationTitle;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * Constructor method for ApplicationCreated
     * @uses ApplicationCreated::setSuccessfull()
     * @uses ApplicationCreated::setAgentID()
     * @uses ApplicationCreated::setCategory()
     * @uses ApplicationCreated::setApplicationCode()
     * @uses ApplicationCreated::setApplicationTitle()
     * @uses ApplicationCreated::setMessage()
     * @param bool $successfull
     * @param string $agentID
     * @param string $category
     * @param string $applicationCode
     * @param string $applicationTitle
     * @param string $message
     */
    public function __construct($successfull = null, $agentID = null, $category = null, $applicationCode = null, $applicationTitle = null, $message = null)
    {
        $this
            ->setSuccessfull($successfull)
            ->setAgentID($agentID)
            ->setCategory($category)
            ->setApplicationCode($applicationCode)
            ->setApplicationTitle($applicationTitle)
            ->setMessage($message);
    }
    /**
     * Get Successfull value
     * @return bool|null
     */
    public function getSuccessfull()
    {
        return $this->Successfull;
    }
    /**
     * Set Successfull value
     * @param bool $successfull
     * @return \StructType\ApplicationCreated
     */
    public function setSuccessfull($successfull = null)
    {
        // validation for constraint: boolean
        if (!is_null($successfull) && !is_bool($successfull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successfull, true), gettype($successfull)), __LINE__);
        }
        $this->Successfull = $successfull;
        return $this;
    }
    /**
     * Get AgentID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgentID()
    {
        return isset($this->AgentID) ? $this->AgentID : null;
    }
    /**
     * Set AgentID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agentID
     * @return \StructType\ApplicationCreated
     */
    public function setAgentID($agentID = null)
    {
        // validation for constraint: string
        if (!is_null($agentID) && !is_string($agentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentID, true), gettype($agentID)), __LINE__);
        }
        if (is_null($agentID) || (is_array($agentID) && empty($agentID))) {
            unset($this->AgentID);
        } else {
            $this->AgentID = $agentID;
        }
        return $this;
    }
    /**
     * Get Category value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategory()
    {
        return isset($this->Category) ? $this->Category : null;
    }
    /**
     * Set Category value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $category
     * @return \StructType\ApplicationCreated
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        if (is_null($category) || (is_array($category) && empty($category))) {
            unset($this->Category);
        } else {
            $this->Category = $category;
        }
        return $this;
    }
    /**
     * Get ApplicationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationCode()
    {
        return isset($this->ApplicationCode) ? $this->ApplicationCode : null;
    }
    /**
     * Set ApplicationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationCode
     * @return \StructType\ApplicationCreated
     */
    public function setApplicationCode($applicationCode = null)
    {
        // validation for constraint: string
        if (!is_null($applicationCode) && !is_string($applicationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationCode, true), gettype($applicationCode)), __LINE__);
        }
        if (is_null($applicationCode) || (is_array($applicationCode) && empty($applicationCode))) {
            unset($this->ApplicationCode);
        } else {
            $this->ApplicationCode = $applicationCode;
        }
        return $this;
    }
    /**
     * Get ApplicationTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationTitle()
    {
        return isset($this->ApplicationTitle) ? $this->ApplicationTitle : null;
    }
    /**
     * Set ApplicationTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationTitle
     * @return \StructType\ApplicationCreated
     */
    public function setApplicationTitle($applicationTitle = null)
    {
        // validation for constraint: string
        if (!is_null($applicationTitle) && !is_string($applicationTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationTitle, true), gettype($applicationTitle)), __LINE__);
        }
        if (is_null($applicationTitle) || (is_array($applicationTitle) && empty($applicationTitle))) {
            unset($this->ApplicationTitle);
        } else {
            $this->ApplicationTitle = $applicationTitle;
        }
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \StructType\ApplicationCreated
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
}
