<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Change ServiceType
 * @subpackage Services
 */
class Change extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ChangeStatusWithSchedule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChangeStatusWithSchedule $parameters
     * @return \StructType\ChangeStatusWithScheduleResponse|bool
     */
    public function ChangeStatusWithSchedule(\StructType\ChangeStatusWithSchedule $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangeStatusWithSchedule($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChangeStatusWithNote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChangeStatusWithNote $parameters
     * @return \StructType\ChangeStatusWithNoteResponse|bool
     */
    public function ChangeStatusWithNote(\StructType\ChangeStatusWithNote $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangeStatusWithNote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ChangeStatusWithNoteResponse|\StructType\ChangeStatusWithScheduleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
