<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Proposed_Supplier_Status_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Proposed Supplier Status data
 * @subpackage Structs
 */
class Proposed_Supplier_Status_DataType extends AbstractStructBase
{
    /**
     * The Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Status Value Reference is a unique reference to a Business Entity Status
     * @var \StructType\Business_Entity_Status_ValueObjectType
     */
    public $Status_Reference;
    /**
     * The Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reason for Supplier Status Change Reference
     * - minOccurs: 0
     * @var \StructType\Reason_for_Supplier_Status_ChangeObjectType
     */
    public $Reason_Reference;
    /**
     * The Reason_Description
     * Meta information extracted from the WSDL
     * - documentation: Status Change Reason Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reason_Description;
    /**
     * Constructor method for Proposed_Supplier_Status_DataType
     * @uses Proposed_Supplier_Status_DataType::setStatus_Reference()
     * @uses Proposed_Supplier_Status_DataType::setReason_Reference()
     * @uses Proposed_Supplier_Status_DataType::setReason_Description()
     * @param \StructType\Business_Entity_Status_ValueObjectType $status_Reference
     * @param \StructType\Reason_for_Supplier_Status_ChangeObjectType $reason_Reference
     * @param string $reason_Description
     */
    public function __construct(\StructType\Business_Entity_Status_ValueObjectType $status_Reference = null, \StructType\Reason_for_Supplier_Status_ChangeObjectType $reason_Reference = null, $reason_Description = null)
    {
        $this
            ->setStatus_Reference($status_Reference)
            ->setReason_Reference($reason_Reference)
            ->setReason_Description($reason_Description);
    }
    /**
     * Get Status_Reference value
     * @return \StructType\Business_Entity_Status_ValueObjectType|null
     */
    public function getStatus_Reference()
    {
        return $this->Status_Reference;
    }
    /**
     * Set Status_Reference value
     * @param \StructType\Business_Entity_Status_ValueObjectType $status_Reference
     * @return \StructType\Proposed_Supplier_Status_DataType
     */
    public function setStatus_Reference(\StructType\Business_Entity_Status_ValueObjectType $status_Reference = null)
    {
        $this->Status_Reference = $status_Reference;
        return $this;
    }
    /**
     * Get Reason_Reference value
     * @return \StructType\Reason_for_Supplier_Status_ChangeObjectType|null
     */
    public function getReason_Reference()
    {
        return $this->Reason_Reference;
    }
    /**
     * Set Reason_Reference value
     * @param \StructType\Reason_for_Supplier_Status_ChangeObjectType $reason_Reference
     * @return \StructType\Proposed_Supplier_Status_DataType
     */
    public function setReason_Reference(\StructType\Reason_for_Supplier_Status_ChangeObjectType $reason_Reference = null)
    {
        $this->Reason_Reference = $reason_Reference;
        return $this;
    }
    /**
     * Get Reason_Description value
     * @return string|null
     */
    public function getReason_Description()
    {
        return $this->Reason_Description;
    }
    /**
     * Set Reason_Description value
     * @param string $reason_Description
     * @return \StructType\Proposed_Supplier_Status_DataType
     */
    public function setReason_Description($reason_Description = null)
    {
        // validation for constraint: string
        if (!is_null($reason_Description) && !is_string($reason_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason_Description, true), gettype($reason_Description)), __LINE__);
        }
        $this->Reason_Description = $reason_Description;
        return $this;
    }
}
