<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Procurement_Card_Transaction_Verification_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element is the wrapper around a list of elements representing the Procurement Card Transaction Verification Request specific criteria needed to search for instances. All of the elements are "AND" conditions.
 * @subpackage Structs
 */
class Procurement_Card_Transaction_Verification_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company Reference for Procurement Card Transaction Verification.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worker Reference for Procurement Card Transaction Verification.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Worker_Reference;
    /**
     * The Verification_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Verification On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Verification_On_or_After;
    /**
     * The Verification_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Verification On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Verification_On_or_Before;
    /**
     * Constructor method for
     * Procurement_Card_Transaction_Verification_Request_CriteriaType
     * @uses Procurement_Card_Transaction_Verification_Request_CriteriaType::setCompany_Reference()
     * @uses Procurement_Card_Transaction_Verification_Request_CriteriaType::setWorker_Reference()
     * @uses Procurement_Card_Transaction_Verification_Request_CriteriaType::setVerification_On_or_After()
     * @uses Procurement_Card_Transaction_Verification_Request_CriteriaType::setVerification_On_or_Before()
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\WorkerObjectType $worker_Reference
     * @param string $verification_On_or_After
     * @param string $verification_On_or_Before
     */
    public function __construct(\StructType\CompanyObjectType $company_Reference = null, \StructType\WorkerObjectType $worker_Reference = null, $verification_On_or_After = null, $verification_On_or_Before = null)
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setWorker_Reference($worker_Reference)
            ->setVerification_On_or_After($verification_On_or_After)
            ->setVerification_On_or_Before($verification_On_or_Before);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_Request_CriteriaType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getWorker_Reference()
    {
        return $this->Worker_Reference;
    }
    /**
     * Set Worker_Reference value
     * @param \StructType\WorkerObjectType $worker_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_Request_CriteriaType
     */
    public function setWorker_Reference(\StructType\WorkerObjectType $worker_Reference = null)
    {
        $this->Worker_Reference = $worker_Reference;
        return $this;
    }
    /**
     * Get Verification_On_or_After value
     * @return string|null
     */
    public function getVerification_On_or_After()
    {
        return $this->Verification_On_or_After;
    }
    /**
     * Set Verification_On_or_After value
     * @param string $verification_On_or_After
     * @return \StructType\Procurement_Card_Transaction_Verification_Request_CriteriaType
     */
    public function setVerification_On_or_After($verification_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($verification_On_or_After) && !is_string($verification_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verification_On_or_After, true), gettype($verification_On_or_After)), __LINE__);
        }
        $this->Verification_On_or_After = $verification_On_or_After;
        return $this;
    }
    /**
     * Get Verification_On_or_Before value
     * @return string|null
     */
    public function getVerification_On_or_Before()
    {
        return $this->Verification_On_or_Before;
    }
    /**
     * Set Verification_On_or_Before value
     * @param string $verification_On_or_Before
     * @return \StructType\Procurement_Card_Transaction_Verification_Request_CriteriaType
     */
    public function setVerification_On_or_Before($verification_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($verification_On_or_Before) && !is_string($verification_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verification_On_or_Before, true), gettype($verification_On_or_Before)), __LINE__);
        }
        $this->Verification_On_or_Before = $verification_On_or_Before;
        return $this;
    }
}
