<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Default_PO_Issue_Email_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: You must enter either email reference or email address. | You must enter a valid email address of type "Business" and usage including "Procurement" for default po issue email. | Default PO Issue Email Data allows the user to select
 * emails specified on Supplier Contact Information to be used as the default Issue Email address on all Purchase Orders.
 * @subpackage Structs
 */
class Default_PO_Issue_Email_DataType extends AbstractStructBase
{
    /**
     * The Email_Reference
     * Meta information extracted from the WSDL
     * - documentation: Internet Email Reference ID to be used as the default email address on Purchase Orders.
     * - minOccurs: 0
     * @var \StructType\Email_ReferenceObjectType
     */
    public $Email_Reference;
    /**
     * The Email_Address
     * Meta information extracted from the WSDL
     * - documentation: Internet Email text field for default PO issue email.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email_Address;
    /**
     * Constructor method for Default_PO_Issue_Email_DataType
     * @uses Default_PO_Issue_Email_DataType::setEmail_Reference()
     * @uses Default_PO_Issue_Email_DataType::setEmail_Address()
     * @param \StructType\Email_ReferenceObjectType $email_Reference
     * @param string $email_Address
     */
    public function __construct(\StructType\Email_ReferenceObjectType $email_Reference = null, $email_Address = null)
    {
        $this
            ->setEmail_Reference($email_Reference)
            ->setEmail_Address($email_Address);
    }
    /**
     * Get Email_Reference value
     * @return \StructType\Email_ReferenceObjectType|null
     */
    public function getEmail_Reference()
    {
        return $this->Email_Reference;
    }
    /**
     * Set Email_Reference value
     * @param \StructType\Email_ReferenceObjectType $email_Reference
     * @return \StructType\Default_PO_Issue_Email_DataType
     */
    public function setEmail_Reference(\StructType\Email_ReferenceObjectType $email_Reference = null)
    {
        $this->Email_Reference = $email_Reference;
        return $this;
    }
    /**
     * Get Email_Address value
     * @return string|null
     */
    public function getEmail_Address()
    {
        return $this->Email_Address;
    }
    /**
     * Set Email_Address value
     * @param string $email_Address
     * @return \StructType\Default_PO_Issue_Email_DataType
     */
    public function setEmail_Address($email_Address = null)
    {
        // validation for constraint: string
        if (!is_null($email_Address) && !is_string($email_Address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email_Address, true), gettype($email_Address)), __LINE__);
        }
        $this->Email_Address = $email_Address;
        return $this;
    }
}
