<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Submit_Procurement_Card_Transaction_Verification_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: You cannot submit this procurement card transaction verification since there are accounting adjustments in approved, in progress or draft status. | You cannot submit this procurement card transaction verification since there are
 * credit card transactions in paid status and the checkbox 'pay unapproved procurement card transactions' option is unselected. | You cannot submit this procurement card transaction verification since the intercompany payment is in progress or paid. |
 * You cannot submit this procurement card transaction verification since the business document is canceled or closed. | The Web Service is set to Add Only; documents cannot be resubmitted. | Element containing Procurement Card Transaction Verification
 * reference for update and all Procurement Card Transaction Verification data items.
 * @subpackage Structs
 */
class Submit_Procurement_Card_Transaction_Verification_RequestType extends AbstractStructBase
{
    /**
     * The Procurement_Card_Transaction_Verification_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Procurement Card Transaction Verification for update only purposes
     * - minOccurs: 0
     * @var \StructType\Procurement_Card_Transaction_VerificationObjectType
     */
    public $Procurement_Card_Transaction_Verification_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Procurement_Card_Transaction_Verification_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Procurement Card Transaction Verification Data.
     * - minOccurs: 0
     * @var \StructType\Procurement_Card_Transaction_Verification_DataType
     */
    public $Procurement_Card_Transaction_Verification_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for
     * Submit_Procurement_Card_Transaction_Verification_RequestType
     * @uses Submit_Procurement_Card_Transaction_Verification_RequestType::setProcurement_Card_Transaction_Verification_Reference()
     * @uses Submit_Procurement_Card_Transaction_Verification_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Procurement_Card_Transaction_Verification_RequestType::setProcurement_Card_Transaction_Verification_Data()
     * @uses Submit_Procurement_Card_Transaction_Verification_RequestType::setAdd_Only()
     * @uses Submit_Procurement_Card_Transaction_Verification_RequestType::setVersion()
     * @param \StructType\Procurement_Card_Transaction_VerificationObjectType $procurement_Card_Transaction_Verification_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Procurement_Card_Transaction_Verification_DataType $procurement_Card_Transaction_Verification_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Procurement_Card_Transaction_VerificationObjectType $procurement_Card_Transaction_Verification_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Procurement_Card_Transaction_Verification_DataType $procurement_Card_Transaction_Verification_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setProcurement_Card_Transaction_Verification_Reference($procurement_Card_Transaction_Verification_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setProcurement_Card_Transaction_Verification_Data($procurement_Card_Transaction_Verification_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Procurement_Card_Transaction_Verification_Reference value
     * @return \StructType\Procurement_Card_Transaction_VerificationObjectType|null
     */
    public function getProcurement_Card_Transaction_Verification_Reference()
    {
        return $this->Procurement_Card_Transaction_Verification_Reference;
    }
    /**
     * Set Procurement_Card_Transaction_Verification_Reference value
     * @param \StructType\Procurement_Card_Transaction_VerificationObjectType $procurement_Card_Transaction_Verification_Reference
     * @return \StructType\Submit_Procurement_Card_Transaction_Verification_RequestType
     */
    public function setProcurement_Card_Transaction_Verification_Reference(\StructType\Procurement_Card_Transaction_VerificationObjectType $procurement_Card_Transaction_Verification_Reference = null)
    {
        $this->Procurement_Card_Transaction_Verification_Reference = $procurement_Card_Transaction_Verification_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Procurement_Card_Transaction_Verification_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Procurement_Card_Transaction_Verification_Data value
     * @return \StructType\Procurement_Card_Transaction_Verification_DataType|null
     */
    public function getProcurement_Card_Transaction_Verification_Data()
    {
        return $this->Procurement_Card_Transaction_Verification_Data;
    }
    /**
     * Set Procurement_Card_Transaction_Verification_Data value
     * @param \StructType\Procurement_Card_Transaction_Verification_DataType $procurement_Card_Transaction_Verification_Data
     * @return \StructType\Submit_Procurement_Card_Transaction_Verification_RequestType
     */
    public function setProcurement_Card_Transaction_Verification_Data(\StructType\Procurement_Card_Transaction_Verification_DataType $procurement_Card_Transaction_Verification_Data = null)
    {
        $this->Procurement_Card_Transaction_Verification_Data = $procurement_Card_Transaction_Verification_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Submit_Procurement_Card_Transaction_Verification_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Procurement_Card_Transaction_Verification_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
