<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Related_Worktags_by_Worktag_Type_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Allowed and Default Related Worktags Data by Worktag Type.
 * @subpackage Structs
 */
class Related_Worktags_by_Worktag_Type_DataType extends AbstractStructBase
{
    /**
     * The Worktag_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Worktag Type Reference ID cannot be duplicated within one request. Valid ID types for all worktag types that can be configured for a related worktag taggable type may include: BUSINESS_SITE, BUSINESS_UNIT, COST_CENTER,
     * CUSTOM_ORGANIZATION_01-10, CUSTOM_WORKTAG_1-10, FUND, GIFT, GRANT, INVESTOR, OPPORTUNITY, PROGRAM, PROJECT, PROJECT_PHASE, PROJECT_TASK, REGION, SALES_ITEM.
     * - minOccurs: 0
     * @var \StructType\Accounting_Worktag_TypeObjectType
     */
    public $Worktag_Type_Reference;
    /**
     * The Required_On_Transaction
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate if the Worktag Type will be required on a transaction when a value for the worktag type that has related values is entered.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Required_On_Transaction;
    /**
     * The Required_On_Transaction_For_Validation
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate if 'Required on Transaction' is enabled in either 'Maintain Related Worktag Usage' or on the Worktag instance. When you generate an EIB template with data, 'y' is returned when either boolean is true. This boolean
     * is informational only in the 'Put' operation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Required_On_Transaction_For_Validation;
    /**
     * The Default_Worktag_Data
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Default Realted Worktag or Add new Default Related Worktag
     * - minOccurs: 0
     * @var \StructType\Default_Worktag_DataType
     */
    public $Default_Worktag_Data;
    /**
     * The Replace_All_Allowed_Values
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate that all existing allowed values are to be deleted. When set to true ('y' in EIB), if allowed values are also specified, they will become the new set of allowed values.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Replace_All_Allowed_Values;
    /**
     * The Allowed_Worktag_Data
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Allowed Related Worktags or Add new Allowed Related Worktags
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Allowed_Worktag_DataType[]
     */
    public $Allowed_Worktag_Data;
    /**
     * Constructor method for Related_Worktags_by_Worktag_Type_DataType
     * @uses Related_Worktags_by_Worktag_Type_DataType::setWorktag_Type_Reference()
     * @uses Related_Worktags_by_Worktag_Type_DataType::setRequired_On_Transaction()
     * @uses Related_Worktags_by_Worktag_Type_DataType::setRequired_On_Transaction_For_Validation()
     * @uses Related_Worktags_by_Worktag_Type_DataType::setDefault_Worktag_Data()
     * @uses Related_Worktags_by_Worktag_Type_DataType::setReplace_All_Allowed_Values()
     * @uses Related_Worktags_by_Worktag_Type_DataType::setAllowed_Worktag_Data()
     * @param \StructType\Accounting_Worktag_TypeObjectType $worktag_Type_Reference
     * @param bool $required_On_Transaction
     * @param bool $required_On_Transaction_For_Validation
     * @param \StructType\Default_Worktag_DataType $default_Worktag_Data
     * @param bool $replace_All_Allowed_Values
     * @param \StructType\Allowed_Worktag_DataType[] $allowed_Worktag_Data
     */
    public function __construct(\StructType\Accounting_Worktag_TypeObjectType $worktag_Type_Reference = null, $required_On_Transaction = null, $required_On_Transaction_For_Validation = null, \StructType\Default_Worktag_DataType $default_Worktag_Data = null, $replace_All_Allowed_Values = null, array $allowed_Worktag_Data = array())
    {
        $this
            ->setWorktag_Type_Reference($worktag_Type_Reference)
            ->setRequired_On_Transaction($required_On_Transaction)
            ->setRequired_On_Transaction_For_Validation($required_On_Transaction_For_Validation)
            ->setDefault_Worktag_Data($default_Worktag_Data)
            ->setReplace_All_Allowed_Values($replace_All_Allowed_Values)
            ->setAllowed_Worktag_Data($allowed_Worktag_Data);
    }
    /**
     * Get Worktag_Type_Reference value
     * @return \StructType\Accounting_Worktag_TypeObjectType|null
     */
    public function getWorktag_Type_Reference()
    {
        return $this->Worktag_Type_Reference;
    }
    /**
     * Set Worktag_Type_Reference value
     * @param \StructType\Accounting_Worktag_TypeObjectType $worktag_Type_Reference
     * @return \StructType\Related_Worktags_by_Worktag_Type_DataType
     */
    public function setWorktag_Type_Reference(\StructType\Accounting_Worktag_TypeObjectType $worktag_Type_Reference = null)
    {
        $this->Worktag_Type_Reference = $worktag_Type_Reference;
        return $this;
    }
    /**
     * Get Required_On_Transaction value
     * @return bool|null
     */
    public function getRequired_On_Transaction()
    {
        return $this->Required_On_Transaction;
    }
    /**
     * Set Required_On_Transaction value
     * @param bool $required_On_Transaction
     * @return \StructType\Related_Worktags_by_Worktag_Type_DataType
     */
    public function setRequired_On_Transaction($required_On_Transaction = null)
    {
        // validation for constraint: boolean
        if (!is_null($required_On_Transaction) && !is_bool($required_On_Transaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($required_On_Transaction, true), gettype($required_On_Transaction)), __LINE__);
        }
        $this->Required_On_Transaction = $required_On_Transaction;
        return $this;
    }
    /**
     * Get Required_On_Transaction_For_Validation value
     * @return bool|null
     */
    public function getRequired_On_Transaction_For_Validation()
    {
        return $this->Required_On_Transaction_For_Validation;
    }
    /**
     * Set Required_On_Transaction_For_Validation value
     * @param bool $required_On_Transaction_For_Validation
     * @return \StructType\Related_Worktags_by_Worktag_Type_DataType
     */
    public function setRequired_On_Transaction_For_Validation($required_On_Transaction_For_Validation = null)
    {
        // validation for constraint: boolean
        if (!is_null($required_On_Transaction_For_Validation) && !is_bool($required_On_Transaction_For_Validation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($required_On_Transaction_For_Validation, true), gettype($required_On_Transaction_For_Validation)), __LINE__);
        }
        $this->Required_On_Transaction_For_Validation = $required_On_Transaction_For_Validation;
        return $this;
    }
    /**
     * Get Default_Worktag_Data value
     * @return \StructType\Default_Worktag_DataType|null
     */
    public function getDefault_Worktag_Data()
    {
        return $this->Default_Worktag_Data;
    }
    /**
     * Set Default_Worktag_Data value
     * @param \StructType\Default_Worktag_DataType $default_Worktag_Data
     * @return \StructType\Related_Worktags_by_Worktag_Type_DataType
     */
    public function setDefault_Worktag_Data(\StructType\Default_Worktag_DataType $default_Worktag_Data = null)
    {
        $this->Default_Worktag_Data = $default_Worktag_Data;
        return $this;
    }
    /**
     * Get Replace_All_Allowed_Values value
     * @return bool|null
     */
    public function getReplace_All_Allowed_Values()
    {
        return $this->Replace_All_Allowed_Values;
    }
    /**
     * Set Replace_All_Allowed_Values value
     * @param bool $replace_All_Allowed_Values
     * @return \StructType\Related_Worktags_by_Worktag_Type_DataType
     */
    public function setReplace_All_Allowed_Values($replace_All_Allowed_Values = null)
    {
        // validation for constraint: boolean
        if (!is_null($replace_All_Allowed_Values) && !is_bool($replace_All_Allowed_Values)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replace_All_Allowed_Values, true), gettype($replace_All_Allowed_Values)), __LINE__);
        }
        $this->Replace_All_Allowed_Values = $replace_All_Allowed_Values;
        return $this;
    }
    /**
     * Get Allowed_Worktag_Data value
     * @return \StructType\Allowed_Worktag_DataType[]|null
     */
    public function getAllowed_Worktag_Data()
    {
        return $this->Allowed_Worktag_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAllowed_Worktag_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllowed_Worktag_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllowed_Worktag_DataForArrayConstraintsFromSetAllowed_Worktag_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $related_Worktags_by_Worktag_Type_DataTypeAllowed_Worktag_DataItem) {
            // validation for constraint: itemType
            if (!$related_Worktags_by_Worktag_Type_DataTypeAllowed_Worktag_DataItem instanceof \StructType\Allowed_Worktag_DataType) {
                $invalidValues[] = is_object($related_Worktags_by_Worktag_Type_DataTypeAllowed_Worktag_DataItem) ? get_class($related_Worktags_by_Worktag_Type_DataTypeAllowed_Worktag_DataItem) : sprintf('%s(%s)', gettype($related_Worktags_by_Worktag_Type_DataTypeAllowed_Worktag_DataItem), var_export($related_Worktags_by_Worktag_Type_DataTypeAllowed_Worktag_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Allowed_Worktag_Data property can only contain items of type \StructType\Allowed_Worktag_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Allowed_Worktag_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Allowed_Worktag_DataType[] $allowed_Worktag_Data
     * @return \StructType\Related_Worktags_by_Worktag_Type_DataType
     */
    public function setAllowed_Worktag_Data(array $allowed_Worktag_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($allowed_Worktag_DataArrayErrorMessage = self::validateAllowed_Worktag_DataForArrayConstraintsFromSetAllowed_Worktag_Data($allowed_Worktag_Data))) {
            throw new \InvalidArgumentException($allowed_Worktag_DataArrayErrorMessage, __LINE__);
        }
        $this->Allowed_Worktag_Data = $allowed_Worktag_Data;
        return $this;
    }
    /**
     * Add item to Allowed_Worktag_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Allowed_Worktag_DataType $item
     * @return \StructType\Related_Worktags_by_Worktag_Type_DataType
     */
    public function addToAllowed_Worktag_Data(\StructType\Allowed_Worktag_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Allowed_Worktag_DataType) {
            throw new \InvalidArgumentException(sprintf('The Allowed_Worktag_Data property can only contain items of type \StructType\Allowed_Worktag_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Allowed_Worktag_Data[] = $item;
        return $this;
    }
}
