<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Order_OutboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Get Purchase Orders Response Data
 * @subpackage Structs
 */
class Purchase_Order_OutboundType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Order.
     * - minOccurs: 0
     * @var \StructType\Purchase_OrderObjectType
     */
    public $Purchase_Order_Reference;
    /**
     * The Purchase_Order_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Outbound_DataType[]
     */
    public $Purchase_Order_Data;
    /**
     * Constructor method for Purchase_Order_OutboundType
     * @uses Purchase_Order_OutboundType::setPurchase_Order_Reference()
     * @uses Purchase_Order_OutboundType::setPurchase_Order_Data()
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @param \StructType\Purchase_Order_Outbound_DataType[] $purchase_Order_Data
     */
    public function __construct(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null, array $purchase_Order_Data = array())
    {
        $this
            ->setPurchase_Order_Reference($purchase_Order_Reference)
            ->setPurchase_Order_Data($purchase_Order_Data);
    }
    /**
     * Get Purchase_Order_Reference value
     * @return \StructType\Purchase_OrderObjectType|null
     */
    public function getPurchase_Order_Reference()
    {
        return $this->Purchase_Order_Reference;
    }
    /**
     * Set Purchase_Order_Reference value
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @return \StructType\Purchase_Order_OutboundType
     */
    public function setPurchase_Order_Reference(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null)
    {
        $this->Purchase_Order_Reference = $purchase_Order_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Data value
     * @return \StructType\Purchase_Order_Outbound_DataType[]|null
     */
    public function getPurchase_Order_Data()
    {
        return $this->Purchase_Order_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_DataForArrayConstraintsFromSetPurchase_Order_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_OutboundTypePurchase_Order_DataItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_OutboundTypePurchase_Order_DataItem instanceof \StructType\Purchase_Order_Outbound_DataType) {
                $invalidValues[] = is_object($purchase_Order_OutboundTypePurchase_Order_DataItem) ? get_class($purchase_Order_OutboundTypePurchase_Order_DataItem) : sprintf('%s(%s)', gettype($purchase_Order_OutboundTypePurchase_Order_DataItem), var_export($purchase_Order_OutboundTypePurchase_Order_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Data property can only contain items of type \StructType\Purchase_Order_Outbound_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Outbound_DataType[] $purchase_Order_Data
     * @return \StructType\Purchase_Order_OutboundType
     */
    public function setPurchase_Order_Data(array $purchase_Order_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_DataArrayErrorMessage = self::validatePurchase_Order_DataForArrayConstraintsFromSetPurchase_Order_Data($purchase_Order_Data))) {
            throw new \InvalidArgumentException($purchase_Order_DataArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Data = $purchase_Order_Data;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Outbound_DataType $item
     * @return \StructType\Purchase_Order_OutboundType
     */
    public function addToPurchase_Order_Data(\StructType\Purchase_Order_Outbound_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Order_Outbound_DataType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Data property can only contain items of type \StructType\Purchase_Order_Outbound_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Data[] = $item;
        return $this;
    }
}
