<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PO_Prepaid_Amortization_Schedule_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Purchase Order Prepaid Spend Amortization Schedule
 * @subpackage Structs
 */
class PO_Prepaid_Amortization_Schedule_WWS_DataType extends AbstractStructBase
{
    /**
     * The Frequency_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Frequency to be used when generating the next prepaid accounting entry.
     * @var \StructType\Frequency_BehaviorObjectType
     */
    public $Frequency_Reference;
    /**
     * The Number_of_Prepayment_Installments
     * Meta information extracted from the WSDL
     * - documentation: The Number of Installments to use when accounting for the Prepaid Amortization.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 12
     * @var float
     */
    public $Number_of_Prepayment_Installments;
    /**
     * The Use_Invoice_Date
     * Meta information extracted from the WSDL
     * - documentation: Use the Invoice Date as the starting date for the first installment.
     * - choice: Use_Invoice_Date | Specified_Date
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var bool
     */
    public $Use_Invoice_Date;
    /**
     * The Specified_Date
     * Meta information extracted from the WSDL
     * - documentation: Use the Specified Date as the starting date for the first installment.
     * - choice: Use_Invoice_Date | Specified_Date
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var string
     */
    public $Specified_Date;
    /**
     * The Include_All_Available_Prepaid_Lines
     * Meta information extracted from the WSDL
     * - documentation: Flag to include all remaining prepaid Purchase Order Lines in this schedule
     * - choice: Include_All_Available_Prepaid_Lines | Prepaid_Purchase_Order_Lines
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var bool
     */
    public $Include_All_Available_Prepaid_Lines;
    /**
     * The Prepaid_Purchase_Order_Lines
     * Meta information extracted from the WSDL
     * - choice: Include_All_Available_Prepaid_Lines | Prepaid_Purchase_Order_Lines
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * @var \StructType\Purchase_Order_Lines_For_Amortization_Schedule_DataType[]
     */
    public $Prepaid_Purchase_Order_Lines;
    /**
     * Constructor method for PO_Prepaid_Amortization_Schedule_WWS_DataType
     * @uses PO_Prepaid_Amortization_Schedule_WWS_DataType::setFrequency_Reference()
     * @uses PO_Prepaid_Amortization_Schedule_WWS_DataType::setNumber_of_Prepayment_Installments()
     * @uses PO_Prepaid_Amortization_Schedule_WWS_DataType::setUse_Invoice_Date()
     * @uses PO_Prepaid_Amortization_Schedule_WWS_DataType::setSpecified_Date()
     * @uses PO_Prepaid_Amortization_Schedule_WWS_DataType::setInclude_All_Available_Prepaid_Lines()
     * @uses PO_Prepaid_Amortization_Schedule_WWS_DataType::setPrepaid_Purchase_Order_Lines()
     * @param \StructType\Frequency_BehaviorObjectType $frequency_Reference
     * @param float $number_of_Prepayment_Installments
     * @param bool $use_Invoice_Date
     * @param string $specified_Date
     * @param bool $include_All_Available_Prepaid_Lines
     * @param \StructType\Purchase_Order_Lines_For_Amortization_Schedule_DataType[] $prepaid_Purchase_Order_Lines
     */
    public function __construct(\StructType\Frequency_BehaviorObjectType $frequency_Reference = null, $number_of_Prepayment_Installments = null, $use_Invoice_Date = null, $specified_Date = null, $include_All_Available_Prepaid_Lines = null, array $prepaid_Purchase_Order_Lines = array())
    {
        $this
            ->setFrequency_Reference($frequency_Reference)
            ->setNumber_of_Prepayment_Installments($number_of_Prepayment_Installments)
            ->setUse_Invoice_Date($use_Invoice_Date)
            ->setSpecified_Date($specified_Date)
            ->setInclude_All_Available_Prepaid_Lines($include_All_Available_Prepaid_Lines)
            ->setPrepaid_Purchase_Order_Lines($prepaid_Purchase_Order_Lines);
    }
    /**
     * Get Frequency_Reference value
     * @return \StructType\Frequency_BehaviorObjectType|null
     */
    public function getFrequency_Reference()
    {
        return $this->Frequency_Reference;
    }
    /**
     * Set Frequency_Reference value
     * @param \StructType\Frequency_BehaviorObjectType $frequency_Reference
     * @return \StructType\PO_Prepaid_Amortization_Schedule_WWS_DataType
     */
    public function setFrequency_Reference(\StructType\Frequency_BehaviorObjectType $frequency_Reference = null)
    {
        $this->Frequency_Reference = $frequency_Reference;
        return $this;
    }
    /**
     * Get Number_of_Prepayment_Installments value
     * @return float|null
     */
    public function getNumber_of_Prepayment_Installments()
    {
        return $this->Number_of_Prepayment_Installments;
    }
    /**
     * Set Number_of_Prepayment_Installments value
     * @param float $number_of_Prepayment_Installments
     * @return \StructType\PO_Prepaid_Amortization_Schedule_WWS_DataType
     */
    public function setNumber_of_Prepayment_Installments($number_of_Prepayment_Installments = null)
    {
        // validation for constraint: float
        if (!is_null($number_of_Prepayment_Installments) && !(is_float($number_of_Prepayment_Installments) || is_numeric($number_of_Prepayment_Installments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number_of_Prepayment_Installments, true), gettype($number_of_Prepayment_Installments)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($number_of_Prepayment_Installments) && mb_strlen(mb_substr($number_of_Prepayment_Installments, false !== mb_strpos($number_of_Prepayment_Installments, '.') ? mb_strpos($number_of_Prepayment_Installments, '.') + 1 : mb_strlen($number_of_Prepayment_Installments))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($number_of_Prepayment_Installments, true), mb_strlen(mb_substr($number_of_Prepayment_Installments, mb_strpos($number_of_Prepayment_Installments, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($number_of_Prepayment_Installments) && $number_of_Prepayment_Installments < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($number_of_Prepayment_Installments, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($number_of_Prepayment_Installments) && mb_strlen(preg_replace('/(\D)/', '', $number_of_Prepayment_Installments)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($number_of_Prepayment_Installments, true), mb_strlen(preg_replace('/(\D)/', '', $number_of_Prepayment_Installments))), __LINE__);
        }
        $this->Number_of_Prepayment_Installments = $number_of_Prepayment_Installments;
        return $this;
    }
    /**
     * Get Use_Invoice_Date value
     * @return bool|null
     */
    public function getUse_Invoice_Date()
    {
        return isset($this->Use_Invoice_Date) ? $this->Use_Invoice_Date : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUse_Invoice_Date method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUse_Invoice_Date method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUse_Invoice_DateForChoiceConstraintsFromSetUse_Invoice_Date($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Specified_Date',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Use_Invoice_Date can\'t be set as the property %s is already set. Only one property must be set among these properties: Use_Invoice_Date, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Use_Invoice_Date value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $use_Invoice_Date
     * @return \StructType\PO_Prepaid_Amortization_Schedule_WWS_DataType
     */
    public function setUse_Invoice_Date($use_Invoice_Date = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Invoice_Date) && !is_bool($use_Invoice_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Invoice_Date, true), gettype($use_Invoice_Date)), __LINE__);
        }
        // validation for constraint: choice(Use_Invoice_Date, Specified_Date)
        if ('' !== ($use_Invoice_DateChoiceErrorMessage = self::validateUse_Invoice_DateForChoiceConstraintsFromSetUse_Invoice_Date($use_Invoice_Date))) {
            throw new \InvalidArgumentException($use_Invoice_DateChoiceErrorMessage, __LINE__);
        }
        if (is_null($use_Invoice_Date) || (is_array($use_Invoice_Date) && empty($use_Invoice_Date))) {
            unset($this->Use_Invoice_Date);
        } else {
            $this->Use_Invoice_Date = $use_Invoice_Date;
        }
        return $this;
    }
    /**
     * Get Specified_Date value
     * @return string|null
     */
    public function getSpecified_Date()
    {
        return isset($this->Specified_Date) ? $this->Specified_Date : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSpecified_Date method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecified_Date method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSpecified_DateForChoiceConstraintsFromSetSpecified_Date($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Use_Invoice_Date',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Specified_Date can\'t be set as the property %s is already set. Only one property must be set among these properties: Specified_Date, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Specified_Date value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $specified_Date
     * @return \StructType\PO_Prepaid_Amortization_Schedule_WWS_DataType
     */
    public function setSpecified_Date($specified_Date = null)
    {
        // validation for constraint: string
        if (!is_null($specified_Date) && !is_string($specified_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specified_Date, true), gettype($specified_Date)), __LINE__);
        }
        // validation for constraint: choice(Use_Invoice_Date, Specified_Date)
        if ('' !== ($specified_DateChoiceErrorMessage = self::validateSpecified_DateForChoiceConstraintsFromSetSpecified_Date($specified_Date))) {
            throw new \InvalidArgumentException($specified_DateChoiceErrorMessage, __LINE__);
        }
        if (is_null($specified_Date) || (is_array($specified_Date) && empty($specified_Date))) {
            unset($this->Specified_Date);
        } else {
            $this->Specified_Date = $specified_Date;
        }
        return $this;
    }
    /**
     * Get Include_All_Available_Prepaid_Lines value
     * @return bool|null
     */
    public function getInclude_All_Available_Prepaid_Lines()
    {
        return isset($this->Include_All_Available_Prepaid_Lines) ? $this->Include_All_Available_Prepaid_Lines : null;
    }
    /**
     * This method is responsible for validating the value passed to the setInclude_All_Available_Prepaid_Lines method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInclude_All_Available_Prepaid_Lines method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateInclude_All_Available_Prepaid_LinesForChoiceConstraintsFromSetInclude_All_Available_Prepaid_Lines($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Prepaid_Purchase_Order_Lines',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Include_All_Available_Prepaid_Lines can\'t be set as the property %s is already set. Only one property must be set among these properties: Include_All_Available_Prepaid_Lines, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Include_All_Available_Prepaid_Lines value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $include_All_Available_Prepaid_Lines
     * @return \StructType\PO_Prepaid_Amortization_Schedule_WWS_DataType
     */
    public function setInclude_All_Available_Prepaid_Lines($include_All_Available_Prepaid_Lines = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_All_Available_Prepaid_Lines) && !is_bool($include_All_Available_Prepaid_Lines)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_All_Available_Prepaid_Lines, true), gettype($include_All_Available_Prepaid_Lines)), __LINE__);
        }
        // validation for constraint: choice(Include_All_Available_Prepaid_Lines, Prepaid_Purchase_Order_Lines)
        if ('' !== ($include_All_Available_Prepaid_LinesChoiceErrorMessage = self::validateInclude_All_Available_Prepaid_LinesForChoiceConstraintsFromSetInclude_All_Available_Prepaid_Lines($include_All_Available_Prepaid_Lines))) {
            throw new \InvalidArgumentException($include_All_Available_Prepaid_LinesChoiceErrorMessage, __LINE__);
        }
        if (is_null($include_All_Available_Prepaid_Lines) || (is_array($include_All_Available_Prepaid_Lines) && empty($include_All_Available_Prepaid_Lines))) {
            unset($this->Include_All_Available_Prepaid_Lines);
        } else {
            $this->Include_All_Available_Prepaid_Lines = $include_All_Available_Prepaid_Lines;
        }
        return $this;
    }
    /**
     * Get Prepaid_Purchase_Order_Lines value
     * @return \StructType\Purchase_Order_Lines_For_Amortization_Schedule_DataType[]|null
     */
    public function getPrepaid_Purchase_Order_Lines()
    {
        return isset($this->Prepaid_Purchase_Order_Lines) ? $this->Prepaid_Purchase_Order_Lines : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPrepaid_Purchase_Order_Lines method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrepaid_Purchase_Order_Lines method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrepaid_Purchase_Order_LinesForArrayConstraintsFromSetPrepaid_Purchase_Order_Lines(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pO_Prepaid_Amortization_Schedule_WWS_DataTypePrepaid_Purchase_Order_LinesItem) {
            // validation for constraint: itemType
            if (!$pO_Prepaid_Amortization_Schedule_WWS_DataTypePrepaid_Purchase_Order_LinesItem instanceof \StructType\Purchase_Order_Lines_For_Amortization_Schedule_DataType) {
                $invalidValues[] = is_object($pO_Prepaid_Amortization_Schedule_WWS_DataTypePrepaid_Purchase_Order_LinesItem) ? get_class($pO_Prepaid_Amortization_Schedule_WWS_DataTypePrepaid_Purchase_Order_LinesItem) : sprintf('%s(%s)', gettype($pO_Prepaid_Amortization_Schedule_WWS_DataTypePrepaid_Purchase_Order_LinesItem), var_export($pO_Prepaid_Amortization_Schedule_WWS_DataTypePrepaid_Purchase_Order_LinesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Prepaid_Purchase_Order_Lines property can only contain items of type \StructType\Purchase_Order_Lines_For_Amortization_Schedule_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setPrepaid_Purchase_Order_Lines method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrepaid_Purchase_Order_Lines method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePrepaid_Purchase_Order_LinesForChoiceConstraintsFromSetPrepaid_Purchase_Order_Lines($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Include_All_Available_Prepaid_Lines',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Prepaid_Purchase_Order_Lines can\'t be set as the property %s is already set. Only one property must be set among these properties: Prepaid_Purchase_Order_Lines, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Prepaid_Purchase_Order_Lines value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Lines_For_Amortization_Schedule_DataType[] $prepaid_Purchase_Order_Lines
     * @return \StructType\PO_Prepaid_Amortization_Schedule_WWS_DataType
     */
    public function setPrepaid_Purchase_Order_Lines(array $prepaid_Purchase_Order_Lines = array())
    {
        // validation for constraint: array
        if ('' !== ($prepaid_Purchase_Order_LinesArrayErrorMessage = self::validatePrepaid_Purchase_Order_LinesForArrayConstraintsFromSetPrepaid_Purchase_Order_Lines($prepaid_Purchase_Order_Lines))) {
            throw new \InvalidArgumentException($prepaid_Purchase_Order_LinesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Include_All_Available_Prepaid_Lines, Prepaid_Purchase_Order_Lines)
        if ('' !== ($prepaid_Purchase_Order_LinesChoiceErrorMessage = self::validatePrepaid_Purchase_Order_LinesForChoiceConstraintsFromSetPrepaid_Purchase_Order_Lines($prepaid_Purchase_Order_Lines))) {
            throw new \InvalidArgumentException($prepaid_Purchase_Order_LinesChoiceErrorMessage, __LINE__);
        }
        if (is_null($prepaid_Purchase_Order_Lines) || (is_array($prepaid_Purchase_Order_Lines) && empty($prepaid_Purchase_Order_Lines))) {
            unset($this->Prepaid_Purchase_Order_Lines);
        } else {
            $this->Prepaid_Purchase_Order_Lines = $prepaid_Purchase_Order_Lines;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToPrepaid_Purchase_Order_Lines method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToPrepaid_Purchase_Order_Lines method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToPrepaid_Purchase_Order_Lines($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Include_All_Available_Prepaid_Lines',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Prepaid_Purchase_Order_Lines can\'t be set as the property %s is already set. Only one property must be set among these properties: Prepaid_Purchase_Order_Lines, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Prepaid_Purchase_Order_Lines value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Lines_For_Amortization_Schedule_DataType $item
     * @return \StructType\PO_Prepaid_Amortization_Schedule_WWS_DataType
     */
    public function addToPrepaid_Purchase_Order_Lines(\StructType\Purchase_Order_Lines_For_Amortization_Schedule_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Order_Lines_For_Amortization_Schedule_DataType) {
            throw new \InvalidArgumentException(sprintf('The Prepaid_Purchase_Order_Lines property can only contain items of type \StructType\Purchase_Order_Lines_For_Amortization_Schedule_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Include_All_Available_Prepaid_Lines, Prepaid_Purchase_Order_Lines)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToPrepaid_Purchase_Order_Lines($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Prepaid_Purchase_Order_Lines[] = $item;
        return $this;
    }
}
