<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Web_Item_Attributes_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Web Item Attributes Response Data Element.
 * @subpackage Structs
 */
class Web_Item_Attributes_Response_DataType extends AbstractStructBase
{
    /**
     * The Web_Item_Attributes
     * Meta information extracted from the WSDL
     * - documentation: Web Item Attibutes.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Web_Item_AttributesType[]
     */
    public $Web_Item_Attributes;
    /**
     * Constructor method for Web_Item_Attributes_Response_DataType
     * @uses Web_Item_Attributes_Response_DataType::setWeb_Item_Attributes()
     * @param \StructType\Web_Item_AttributesType[] $web_Item_Attributes
     */
    public function __construct(array $web_Item_Attributes = array())
    {
        $this
            ->setWeb_Item_Attributes($web_Item_Attributes);
    }
    /**
     * Get Web_Item_Attributes value
     * @return \StructType\Web_Item_AttributesType[]|null
     */
    public function getWeb_Item_Attributes()
    {
        return $this->Web_Item_Attributes;
    }
    /**
     * This method is responsible for validating the values passed to the setWeb_Item_Attributes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeb_Item_Attributes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeb_Item_AttributesForArrayConstraintsFromSetWeb_Item_Attributes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $web_Item_Attributes_Response_DataTypeWeb_Item_AttributesItem) {
            // validation for constraint: itemType
            if (!$web_Item_Attributes_Response_DataTypeWeb_Item_AttributesItem instanceof \StructType\Web_Item_AttributesType) {
                $invalidValues[] = is_object($web_Item_Attributes_Response_DataTypeWeb_Item_AttributesItem) ? get_class($web_Item_Attributes_Response_DataTypeWeb_Item_AttributesItem) : sprintf('%s(%s)', gettype($web_Item_Attributes_Response_DataTypeWeb_Item_AttributesItem), var_export($web_Item_Attributes_Response_DataTypeWeb_Item_AttributesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Web_Item_Attributes property can only contain items of type \StructType\Web_Item_AttributesType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Web_Item_Attributes value
     * @throws \InvalidArgumentException
     * @param \StructType\Web_Item_AttributesType[] $web_Item_Attributes
     * @return \StructType\Web_Item_Attributes_Response_DataType
     */
    public function setWeb_Item_Attributes(array $web_Item_Attributes = array())
    {
        // validation for constraint: array
        if ('' !== ($web_Item_AttributesArrayErrorMessage = self::validateWeb_Item_AttributesForArrayConstraintsFromSetWeb_Item_Attributes($web_Item_Attributes))) {
            throw new \InvalidArgumentException($web_Item_AttributesArrayErrorMessage, __LINE__);
        }
        $this->Web_Item_Attributes = $web_Item_Attributes;
        return $this;
    }
    /**
     * Add item to Web_Item_Attributes value
     * @throws \InvalidArgumentException
     * @param \StructType\Web_Item_AttributesType $item
     * @return \StructType\Web_Item_Attributes_Response_DataType
     */
    public function addToWeb_Item_Attributes(\StructType\Web_Item_AttributesType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Web_Item_AttributesType) {
            throw new \InvalidArgumentException(sprintf('The Web_Item_Attributes property can only contain items of type \StructType\Web_Item_AttributesType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Web_Item_Attributes[] = $item;
        return $this;
    }
}
