<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Receivable_Repayment_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Web Service is set to Add Only; documents cannot be resubmitted. | Element containing Receivable Repayment reference for update and all Receivable Repayment data items.
 * @subpackage Structs
 */
class Put_Receivable_Repayment_RequestType extends AbstractStructBase
{
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Add_Only;
    /**
     * The Receivable_Repayment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Receivable Repayment for update only purposes.
     * - minOccurs: 0
     * @var \StructType\Receivable_RepaymentObjectType
     */
    public $Receivable_Repayment_Reference;
    /**
     * The Receivable_Repayment_Data
     * @var \StructType\Receivable_Repayment_WWS_DataType
     */
    public $Receivable_Repayment_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Receivable_Repayment_RequestType
     * @uses Put_Receivable_Repayment_RequestType::setAdd_Only()
     * @uses Put_Receivable_Repayment_RequestType::setReceivable_Repayment_Reference()
     * @uses Put_Receivable_Repayment_RequestType::setReceivable_Repayment_Data()
     * @uses Put_Receivable_Repayment_RequestType::setVersion()
     * @param bool $add_Only
     * @param \StructType\Receivable_RepaymentObjectType $receivable_Repayment_Reference
     * @param \StructType\Receivable_Repayment_WWS_DataType $receivable_Repayment_Data
     * @param string $version
     */
    public function __construct($add_Only = null, \StructType\Receivable_RepaymentObjectType $receivable_Repayment_Reference = null, \StructType\Receivable_Repayment_WWS_DataType $receivable_Repayment_Data = null, $version = null)
    {
        $this
            ->setAdd_Only($add_Only)
            ->setReceivable_Repayment_Reference($receivable_Repayment_Reference)
            ->setReceivable_Repayment_Data($receivable_Repayment_Data)
            ->setVersion($version);
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Receivable_Repayment_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get Receivable_Repayment_Reference value
     * @return \StructType\Receivable_RepaymentObjectType|null
     */
    public function getReceivable_Repayment_Reference()
    {
        return $this->Receivable_Repayment_Reference;
    }
    /**
     * Set Receivable_Repayment_Reference value
     * @param \StructType\Receivable_RepaymentObjectType $receivable_Repayment_Reference
     * @return \StructType\Put_Receivable_Repayment_RequestType
     */
    public function setReceivable_Repayment_Reference(\StructType\Receivable_RepaymentObjectType $receivable_Repayment_Reference = null)
    {
        $this->Receivable_Repayment_Reference = $receivable_Repayment_Reference;
        return $this;
    }
    /**
     * Get Receivable_Repayment_Data value
     * @return \StructType\Receivable_Repayment_WWS_DataType|null
     */
    public function getReceivable_Repayment_Data()
    {
        return $this->Receivable_Repayment_Data;
    }
    /**
     * Set Receivable_Repayment_Data value
     * @param \StructType\Receivable_Repayment_WWS_DataType $receivable_Repayment_Data
     * @return \StructType\Put_Receivable_Repayment_RequestType
     */
    public function setReceivable_Repayment_Data(\StructType\Receivable_Repayment_WWS_DataType $receivable_Repayment_Data = null)
    {
        $this->Receivable_Repayment_Data = $receivable_Repayment_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Receivable_Repayment_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
