<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Project_Asset_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Project Asset Quantity must be between 1 and 500. Enter a valid quantity. | You can't modify quantities for project assets that contain capitalized costs. | You can only change the Capitalization Date when the asset status is
 * Pending Registration. | Specify a Capitalization Date for assets in Pending Registration status. | To add a project asset, the project must be a capital project. | Spend Category cannot be modified for Project Asset with Business Asset | Project
 * assigned to existing Project Asset cannot be edited. | The Web Service is set to Add Only; but the Project Asset already exists. | Request Element for Putting a Project Asset via a Web Service
 * @subpackage Structs
 */
class Put_Project_Asset_RequestType extends AbstractStructBase
{
    /**
     * The Project_Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Project Asset for update only purposes.
     * - minOccurs: 0
     * @var \StructType\Project_AssetObjectType
     */
    public $Project_Asset_Reference;
    /**
     * The Project_Asset_Data
     * @var \StructType\Project_Asset_DataType
     */
    public $Project_Asset_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Project_Asset_RequestType
     * @uses Put_Project_Asset_RequestType::setProject_Asset_Reference()
     * @uses Put_Project_Asset_RequestType::setProject_Asset_Data()
     * @uses Put_Project_Asset_RequestType::setAdd_Only()
     * @uses Put_Project_Asset_RequestType::setVersion()
     * @param \StructType\Project_AssetObjectType $project_Asset_Reference
     * @param \StructType\Project_Asset_DataType $project_Asset_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Project_AssetObjectType $project_Asset_Reference = null, \StructType\Project_Asset_DataType $project_Asset_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setProject_Asset_Reference($project_Asset_Reference)
            ->setProject_Asset_Data($project_Asset_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Project_Asset_Reference value
     * @return \StructType\Project_AssetObjectType|null
     */
    public function getProject_Asset_Reference()
    {
        return $this->Project_Asset_Reference;
    }
    /**
     * Set Project_Asset_Reference value
     * @param \StructType\Project_AssetObjectType $project_Asset_Reference
     * @return \StructType\Put_Project_Asset_RequestType
     */
    public function setProject_Asset_Reference(\StructType\Project_AssetObjectType $project_Asset_Reference = null)
    {
        $this->Project_Asset_Reference = $project_Asset_Reference;
        return $this;
    }
    /**
     * Get Project_Asset_Data value
     * @return \StructType\Project_Asset_DataType|null
     */
    public function getProject_Asset_Data()
    {
        return $this->Project_Asset_Data;
    }
    /**
     * Set Project_Asset_Data value
     * @param \StructType\Project_Asset_DataType $project_Asset_Data
     * @return \StructType\Put_Project_Asset_RequestType
     */
    public function setProject_Asset_Data(\StructType\Project_Asset_DataType $project_Asset_Data = null)
    {
        $this->Project_Asset_Data = $project_Asset_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Project_Asset_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Project_Asset_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
