<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Goods Purchase Order Line Data
 * @subpackage Structs
 */
class Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Line_Canceled
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the Purchase Order Line is Canceled.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Purchase_Order_Line_Canceled;
    /**
     * The SKU
     * Meta information extracted from the WSDL
     * - documentation: Supplier Part ID as provided by the Supplier.cXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemID/SupplierPartID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SKU;
    /**
     * The Aux_SKU
     * Meta information extracted from the WSDL
     * - documentation: Supplier Part AuxiliaryID as provided by the Supplier.cXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemID/SupplierPartAuxiliaryID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aux_SKU;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Unit_of_Measure_Code
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Line Unit Of Measure UN CEFACT Common code.cXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/UnitOfMeasure
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Unit_of_Measure_Code;
    /**
     * The Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: Unit Cost for the Spend Authorization Line | Installment Line Unit Cost. If you supply this value as an override, you must also enable the Override Line flag. The Unit Cost can only be entered for Supplier Invoice Schedules
     * distributed by Amount. | Unit Cost for Return. If not provided this will be derived from the parent document line. | Unit cost of the asset component. | This is the Unit Price. If this is blank, Workday will default the unit price from the item if
     * one is configured. If invoice line has a quantity and unit price, then Workday will automatically calculate extended amount.. But if the line references either a Service or Project-Based Purchase Order or Contract Line, the Unit Price must be blank.
     * | Unit Cost on RFQ Award Line | The unit cost of the item specified in the currency associated to the Purchase Order currency. | Unit Cost on the Internal Service Delivery line. | Unit Cost of the Service provided. This is required only if Quantity
     * is also specified on the Internal Service Delivery Line. | Unit Cost on the Supplier Invoice Request Line | This is the Unit Price. | Refers to the item unit cost on the POA line. | Purchase Order Line Unit CostcXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/UnitPrice | Unit Cost for Requisition Line | Unit Cost | Unit Cost for Receipt Adjustment Line. This field is outbound only; any data submitted will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Cost;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Resource_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Spend Category
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Resource_Category_Reference;
    /**
     * The Ship_To
     * Meta information extracted from the WSDL
     * - documentation: Ship to Address
     * - minOccurs: 0
     * @var \StructType\Ship_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public $Ship_To;
    /**
     * The Ship_To_Contact
     * Meta information extracted from the WSDL
     * - documentation: Ship To Contact Information
     * - minOccurs: 0
     * @var \StructType\Ship_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public $Ship_To_Contact;
    /**
     * The Deliver_To_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: The location where the items will be delivered.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Deliver_To_Location_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: This transaction header memo will print on the delivered transaction. It is optional freeform text
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Item_Description
     * Meta information extracted from the WSDL
     * - documentation: Item Description as provided by Supplier, or Purchase Order Line Memo if no description is presentcXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Description;
    /**
     * The UNSPSC_Code
     * Meta information extracted from the WSDL
     * - documentation: UNSPSC Code | Catalog Item UNSPSC code for Spend Category | UNSPSC code as provided by the Supplier or if missing, the start UNSPSC code on the Spend Category UNSPSC range.cXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/Classification@domain[UNSPSC]
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $UNSPSC_Code;
    /**
     * The Line_Number
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var float
     */
    public $Line_Number;
    /**
     * The Storage_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Location for the goods item(s) on the Purchase Order Line
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Storage_Location_Reference;
    /**
     * The Alternate_Item_Identifier
     * Meta information extracted from the WSDL
     * - documentation: Alternate Item Identifier
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Alternate_Item_Identifier_for_PO_issue_DataType[]
     */
    public $Alternate_Item_Identifier;
    /**
     * The Cart_Line_Extrinsic
     * Meta information extracted from the WSDL
     * - documentation: Cart Line Extrinsic Name and Value
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Cart_Line_Extrinsic_Name_and_ValueType[]
     */
    public $Cart_Line_Extrinsic;
    /**
     * The Is_Adhoc
     * Meta information extracted from the WSDL
     * - documentation: Returns True if PO line does not correspond to a Cart Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Is_Adhoc;
    /**
     * The Cost_Center_Reference
     * Meta information extracted from the WSDL
     * - documentation: Cost Center on Purchase Order Line
     * - minOccurs: 0
     * @var \StructType\Cost_CenterObjectType
     */
    public $Cost_Center_Reference;
    /**
     * The Purchase_Order_Line_Worktags_Data
     * Meta information extracted from the WSDL
     * - documentation: Returns the Worktags on Purchase Order line along with Spend Category, Location and Item (Purchase Item or Catalog Item).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Oder_Line_Worktags_DataType[]
     */
    public $Purchase_Order_Line_Worktags_Data;
    /**
     * The ISO8601_Requested_Delivery_Date
     * Meta information extracted from the WSDL
     * - documentation: The date item was requested for delivery.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ISO8601_Requested_Delivery_Date;
    /**
     * Constructor method for
     * Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setPurchase_Order_Line_Canceled()
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setSKU()
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setAux_SKU()
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setQuantity()
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setUnit_of_Measure_Code()
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setUnit_Cost()
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setExtended_Amount()
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setResource_Category_Reference()
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setShip_To()
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setShip_To_Contact()
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setDeliver_To_Location_Reference()
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setMemo()
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setItem_Description()
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setUNSPSC_Code()
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setLine_Number()
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setStorage_Location_Reference()
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setAlternate_Item_Identifier()
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setCart_Line_Extrinsic()
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setIs_Adhoc()
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setCost_Center_Reference()
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setPurchase_Order_Line_Worktags_Data()
     * @uses Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setISO8601_Requested_Delivery_Date()
     * @param bool $purchase_Order_Line_Canceled
     * @param string $sKU
     * @param string $aux_SKU
     * @param float $quantity
     * @param string $unit_of_Measure_Code
     * @param float $unit_Cost
     * @param float $extended_Amount
     * @param \StructType\Spend_CategoryObjectType $resource_Category_Reference
     * @param \StructType\Ship_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType $ship_To
     * @param \StructType\Ship_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType $ship_To_Contact
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @param string $memo
     * @param string $item_Description
     * @param float $uNSPSC_Code
     * @param float $line_Number
     * @param \StructType\LocationObjectType $storage_Location_Reference
     * @param \StructType\Alternate_Item_Identifier_for_PO_issue_DataType[] $alternate_Item_Identifier
     * @param \StructType\Cart_Line_Extrinsic_Name_and_ValueType[] $cart_Line_Extrinsic
     * @param bool $is_Adhoc
     * @param \StructType\Cost_CenterObjectType $cost_Center_Reference
     * @param \StructType\Purchase_Oder_Line_Worktags_DataType[] $purchase_Order_Line_Worktags_Data
     * @param string $iSO8601_Requested_Delivery_Date
     */
    public function __construct($purchase_Order_Line_Canceled = null, $sKU = null, $aux_SKU = null, $quantity = null, $unit_of_Measure_Code = null, $unit_Cost = null, $extended_Amount = null, \StructType\Spend_CategoryObjectType $resource_Category_Reference = null, \StructType\Ship_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType $ship_To = null, \StructType\Ship_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType $ship_To_Contact = null, \StructType\LocationObjectType $deliver_To_Location_Reference = null, $memo = null, $item_Description = null, $uNSPSC_Code = null, $line_Number = null, \StructType\LocationObjectType $storage_Location_Reference = null, array $alternate_Item_Identifier = array(), array $cart_Line_Extrinsic = array(), $is_Adhoc = null, \StructType\Cost_CenterObjectType $cost_Center_Reference = null, array $purchase_Order_Line_Worktags_Data = array(), $iSO8601_Requested_Delivery_Date = null)
    {
        $this
            ->setPurchase_Order_Line_Canceled($purchase_Order_Line_Canceled)
            ->setSKU($sKU)
            ->setAux_SKU($aux_SKU)
            ->setQuantity($quantity)
            ->setUnit_of_Measure_Code($unit_of_Measure_Code)
            ->setUnit_Cost($unit_Cost)
            ->setExtended_Amount($extended_Amount)
            ->setResource_Category_Reference($resource_Category_Reference)
            ->setShip_To($ship_To)
            ->setShip_To_Contact($ship_To_Contact)
            ->setDeliver_To_Location_Reference($deliver_To_Location_Reference)
            ->setMemo($memo)
            ->setItem_Description($item_Description)
            ->setUNSPSC_Code($uNSPSC_Code)
            ->setLine_Number($line_Number)
            ->setStorage_Location_Reference($storage_Location_Reference)
            ->setAlternate_Item_Identifier($alternate_Item_Identifier)
            ->setCart_Line_Extrinsic($cart_Line_Extrinsic)
            ->setIs_Adhoc($is_Adhoc)
            ->setCost_Center_Reference($cost_Center_Reference)
            ->setPurchase_Order_Line_Worktags_Data($purchase_Order_Line_Worktags_Data)
            ->setISO8601_Requested_Delivery_Date($iSO8601_Requested_Delivery_Date);
    }
    /**
     * Get Purchase_Order_Line_Canceled value
     * @return bool|null
     */
    public function getPurchase_Order_Line_Canceled()
    {
        return $this->Purchase_Order_Line_Canceled;
    }
    /**
     * Set Purchase_Order_Line_Canceled value
     * @param bool $purchase_Order_Line_Canceled
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setPurchase_Order_Line_Canceled($purchase_Order_Line_Canceled = null)
    {
        // validation for constraint: boolean
        if (!is_null($purchase_Order_Line_Canceled) && !is_bool($purchase_Order_Line_Canceled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($purchase_Order_Line_Canceled, true), gettype($purchase_Order_Line_Canceled)), __LINE__);
        }
        $this->Purchase_Order_Line_Canceled = $purchase_Order_Line_Canceled;
        return $this;
    }
    /**
     * Get SKU value
     * @return string|null
     */
    public function getSKU()
    {
        return $this->SKU;
    }
    /**
     * Set SKU value
     * @param string $sKU
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setSKU($sKU = null)
    {
        // validation for constraint: string
        if (!is_null($sKU) && !is_string($sKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sKU, true), gettype($sKU)), __LINE__);
        }
        $this->SKU = $sKU;
        return $this;
    }
    /**
     * Get Aux_SKU value
     * @return string|null
     */
    public function getAux_SKU()
    {
        return $this->Aux_SKU;
    }
    /**
     * Set Aux_SKU value
     * @param string $aux_SKU
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setAux_SKU($aux_SKU = null)
    {
        // validation for constraint: string
        if (!is_null($aux_SKU) && !is_string($aux_SKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aux_SKU, true), gettype($aux_SKU)), __LINE__);
        }
        $this->Aux_SKU = $aux_SKU;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Code value
     * @return string|null
     */
    public function getUnit_of_Measure_Code()
    {
        return $this->Unit_of_Measure_Code;
    }
    /**
     * Set Unit_of_Measure_Code value
     * @param string $unit_of_Measure_Code
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setUnit_of_Measure_Code($unit_of_Measure_Code = null)
    {
        // validation for constraint: string
        if (!is_null($unit_of_Measure_Code) && !is_string($unit_of_Measure_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unit_of_Measure_Code, true), gettype($unit_of_Measure_Code)), __LINE__);
        }
        $this->Unit_of_Measure_Code = $unit_of_Measure_Code;
        return $this;
    }
    /**
     * Get Unit_Cost value
     * @return float|null
     */
    public function getUnit_Cost()
    {
        return $this->Unit_Cost;
    }
    /**
     * Set Unit_Cost value
     * @param float $unit_Cost
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setUnit_Cost($unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Cost) && !(is_float($unit_Cost) || is_numeric($unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Cost, true), gettype($unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Cost) && mb_strlen(mb_substr($unit_Cost, false !== mb_strpos($unit_Cost, '.') ? mb_strpos($unit_Cost, '.') + 1 : mb_strlen($unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Cost, true), mb_strlen(mb_substr($unit_Cost, mb_strpos($unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Cost))), __LINE__);
        }
        $this->Unit_Cost = $unit_Cost;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Resource_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getResource_Category_Reference()
    {
        return $this->Resource_Category_Reference;
    }
    /**
     * Set Resource_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $resource_Category_Reference
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setResource_Category_Reference(\StructType\Spend_CategoryObjectType $resource_Category_Reference = null)
    {
        $this->Resource_Category_Reference = $resource_Category_Reference;
        return $this;
    }
    /**
     * Get Ship_To value
     * @return \StructType\Ship_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType|null
     */
    public function getShip_To()
    {
        return $this->Ship_To;
    }
    /**
     * Set Ship_To value
     * @param \StructType\Ship_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType $ship_To
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setShip_To(\StructType\Ship_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType $ship_To = null)
    {
        $this->Ship_To = $ship_To;
        return $this;
    }
    /**
     * Get Ship_To_Contact value
     * @return \StructType\Ship_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType|null
     */
    public function getShip_To_Contact()
    {
        return $this->Ship_To_Contact;
    }
    /**
     * Set Ship_To_Contact value
     * @param \StructType\Ship_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType $ship_To_Contact
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setShip_To_Contact(\StructType\Ship_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType $ship_To_Contact = null)
    {
        $this->Ship_To_Contact = $ship_To_Contact;
        return $this;
    }
    /**
     * Get Deliver_To_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getDeliver_To_Location_Reference()
    {
        return $this->Deliver_To_Location_Reference;
    }
    /**
     * Set Deliver_To_Location_Reference value
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setDeliver_To_Location_Reference(\StructType\LocationObjectType $deliver_To_Location_Reference = null)
    {
        $this->Deliver_To_Location_Reference = $deliver_To_Location_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Item_Description value
     * @return string|null
     */
    public function getItem_Description()
    {
        return $this->Item_Description;
    }
    /**
     * Set Item_Description value
     * @param string $item_Description
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setItem_Description($item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($item_Description) && !is_string($item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Description, true), gettype($item_Description)), __LINE__);
        }
        $this->Item_Description = $item_Description;
        return $this;
    }
    /**
     * Get UNSPSC_Code value
     * @return float|null
     */
    public function getUNSPSC_Code()
    {
        return $this->UNSPSC_Code;
    }
    /**
     * Set UNSPSC_Code value
     * @param float $uNSPSC_Code
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setUNSPSC_Code($uNSPSC_Code = null)
    {
        // validation for constraint: float
        if (!is_null($uNSPSC_Code) && !(is_float($uNSPSC_Code) || is_numeric($uNSPSC_Code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($uNSPSC_Code, true), gettype($uNSPSC_Code)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($uNSPSC_Code) && mb_strlen(mb_substr($uNSPSC_Code, false !== mb_strpos($uNSPSC_Code, '.') ? mb_strpos($uNSPSC_Code, '.') + 1 : mb_strlen($uNSPSC_Code))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($uNSPSC_Code, true), mb_strlen(mb_substr($uNSPSC_Code, mb_strpos($uNSPSC_Code, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($uNSPSC_Code) && $uNSPSC_Code < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($uNSPSC_Code, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($uNSPSC_Code) && mb_strlen(preg_replace('/(\D)/', '', $uNSPSC_Code)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($uNSPSC_Code, true), mb_strlen(preg_replace('/(\D)/', '', $uNSPSC_Code))), __LINE__);
        }
        $this->UNSPSC_Code = $uNSPSC_Code;
        return $this;
    }
    /**
     * Get Line_Number value
     * @return float|null
     */
    public function getLine_Number()
    {
        return $this->Line_Number;
    }
    /**
     * Set Line_Number value
     * @param float $line_Number
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setLine_Number($line_Number = null)
    {
        // validation for constraint: float
        if (!is_null($line_Number) && !(is_float($line_Number) || is_numeric($line_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($line_Number, true), gettype($line_Number)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($line_Number) && mb_strlen(mb_substr($line_Number, false !== mb_strpos($line_Number, '.') ? mb_strpos($line_Number, '.') + 1 : mb_strlen($line_Number))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($line_Number, true), mb_strlen(mb_substr($line_Number, mb_strpos($line_Number, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($line_Number) && $line_Number < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($line_Number, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($line_Number) && mb_strlen(preg_replace('/(\D)/', '', $line_Number)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($line_Number, true), mb_strlen(preg_replace('/(\D)/', '', $line_Number))), __LINE__);
        }
        $this->Line_Number = $line_Number;
        return $this;
    }
    /**
     * Get Storage_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getStorage_Location_Reference()
    {
        return $this->Storage_Location_Reference;
    }
    /**
     * Set Storage_Location_Reference value
     * @param \StructType\LocationObjectType $storage_Location_Reference
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setStorage_Location_Reference(\StructType\LocationObjectType $storage_Location_Reference = null)
    {
        $this->Storage_Location_Reference = $storage_Location_Reference;
        return $this;
    }
    /**
     * Get Alternate_Item_Identifier value
     * @return \StructType\Alternate_Item_Identifier_for_PO_issue_DataType[]|null
     */
    public function getAlternate_Item_Identifier()
    {
        return $this->Alternate_Item_Identifier;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternate_Item_Identifier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternate_Item_Identifier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternate_Item_IdentifierForArrayConstraintsFromSetAlternate_Item_Identifier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeAlternate_Item_IdentifierItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeAlternate_Item_IdentifierItem instanceof \StructType\Alternate_Item_Identifier_for_PO_issue_DataType) {
                $invalidValues[] = is_object($purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeAlternate_Item_IdentifierItem) ? get_class($purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeAlternate_Item_IdentifierItem) : sprintf('%s(%s)', gettype($purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeAlternate_Item_IdentifierItem), var_export($purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeAlternate_Item_IdentifierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alternate_Item_Identifier property can only contain items of type \StructType\Alternate_Item_Identifier_for_PO_issue_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alternate_Item_Identifier value
     * @throws \InvalidArgumentException
     * @param \StructType\Alternate_Item_Identifier_for_PO_issue_DataType[] $alternate_Item_Identifier
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setAlternate_Item_Identifier(array $alternate_Item_Identifier = array())
    {
        // validation for constraint: array
        if ('' !== ($alternate_Item_IdentifierArrayErrorMessage = self::validateAlternate_Item_IdentifierForArrayConstraintsFromSetAlternate_Item_Identifier($alternate_Item_Identifier))) {
            throw new \InvalidArgumentException($alternate_Item_IdentifierArrayErrorMessage, __LINE__);
        }
        $this->Alternate_Item_Identifier = $alternate_Item_Identifier;
        return $this;
    }
    /**
     * Add item to Alternate_Item_Identifier value
     * @throws \InvalidArgumentException
     * @param \StructType\Alternate_Item_Identifier_for_PO_issue_DataType $item
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function addToAlternate_Item_Identifier(\StructType\Alternate_Item_Identifier_for_PO_issue_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Alternate_Item_Identifier_for_PO_issue_DataType) {
            throw new \InvalidArgumentException(sprintf('The Alternate_Item_Identifier property can only contain items of type \StructType\Alternate_Item_Identifier_for_PO_issue_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alternate_Item_Identifier[] = $item;
        return $this;
    }
    /**
     * Get Cart_Line_Extrinsic value
     * @return \StructType\Cart_Line_Extrinsic_Name_and_ValueType[]|null
     */
    public function getCart_Line_Extrinsic()
    {
        return $this->Cart_Line_Extrinsic;
    }
    /**
     * This method is responsible for validating the values passed to the setCart_Line_Extrinsic method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCart_Line_Extrinsic method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCart_Line_ExtrinsicForArrayConstraintsFromSetCart_Line_Extrinsic(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeCart_Line_ExtrinsicItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeCart_Line_ExtrinsicItem instanceof \StructType\Cart_Line_Extrinsic_Name_and_ValueType) {
                $invalidValues[] = is_object($purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeCart_Line_ExtrinsicItem) ? get_class($purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeCart_Line_ExtrinsicItem) : sprintf('%s(%s)', gettype($purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeCart_Line_ExtrinsicItem), var_export($purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeCart_Line_ExtrinsicItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Cart_Line_Extrinsic property can only contain items of type \StructType\Cart_Line_Extrinsic_Name_and_ValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Cart_Line_Extrinsic value
     * @throws \InvalidArgumentException
     * @param \StructType\Cart_Line_Extrinsic_Name_and_ValueType[] $cart_Line_Extrinsic
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setCart_Line_Extrinsic(array $cart_Line_Extrinsic = array())
    {
        // validation for constraint: array
        if ('' !== ($cart_Line_ExtrinsicArrayErrorMessage = self::validateCart_Line_ExtrinsicForArrayConstraintsFromSetCart_Line_Extrinsic($cart_Line_Extrinsic))) {
            throw new \InvalidArgumentException($cart_Line_ExtrinsicArrayErrorMessage, __LINE__);
        }
        $this->Cart_Line_Extrinsic = $cart_Line_Extrinsic;
        return $this;
    }
    /**
     * Add item to Cart_Line_Extrinsic value
     * @throws \InvalidArgumentException
     * @param \StructType\Cart_Line_Extrinsic_Name_and_ValueType $item
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function addToCart_Line_Extrinsic(\StructType\Cart_Line_Extrinsic_Name_and_ValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Cart_Line_Extrinsic_Name_and_ValueType) {
            throw new \InvalidArgumentException(sprintf('The Cart_Line_Extrinsic property can only contain items of type \StructType\Cart_Line_Extrinsic_Name_and_ValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Cart_Line_Extrinsic[] = $item;
        return $this;
    }
    /**
     * Get Is_Adhoc value
     * @return bool|null
     */
    public function getIs_Adhoc()
    {
        return $this->Is_Adhoc;
    }
    /**
     * Set Is_Adhoc value
     * @param bool $is_Adhoc
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setIs_Adhoc($is_Adhoc = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_Adhoc) && !is_bool($is_Adhoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($is_Adhoc, true), gettype($is_Adhoc)), __LINE__);
        }
        $this->Is_Adhoc = $is_Adhoc;
        return $this;
    }
    /**
     * Get Cost_Center_Reference value
     * @return \StructType\Cost_CenterObjectType|null
     */
    public function getCost_Center_Reference()
    {
        return $this->Cost_Center_Reference;
    }
    /**
     * Set Cost_Center_Reference value
     * @param \StructType\Cost_CenterObjectType $cost_Center_Reference
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setCost_Center_Reference(\StructType\Cost_CenterObjectType $cost_Center_Reference = null)
    {
        $this->Cost_Center_Reference = $cost_Center_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Line_Worktags_Data value
     * @return \StructType\Purchase_Oder_Line_Worktags_DataType[]|null
     */
    public function getPurchase_Order_Line_Worktags_Data()
    {
        return $this->Purchase_Order_Line_Worktags_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Line_Worktags_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Line_Worktags_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_Line_Worktags_DataForArrayConstraintsFromSetPurchase_Order_Line_Worktags_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypePurchase_Order_Line_Worktags_DataItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypePurchase_Order_Line_Worktags_DataItem instanceof \StructType\Purchase_Oder_Line_Worktags_DataType) {
                $invalidValues[] = is_object($purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypePurchase_Order_Line_Worktags_DataItem) ? get_class($purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypePurchase_Order_Line_Worktags_DataItem) : sprintf('%s(%s)', gettype($purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypePurchase_Order_Line_Worktags_DataItem), var_export($purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypePurchase_Order_Line_Worktags_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Line_Worktags_Data property can only contain items of type \StructType\Purchase_Oder_Line_Worktags_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Line_Worktags_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Oder_Line_Worktags_DataType[] $purchase_Order_Line_Worktags_Data
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setPurchase_Order_Line_Worktags_Data(array $purchase_Order_Line_Worktags_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_Line_Worktags_DataArrayErrorMessage = self::validatePurchase_Order_Line_Worktags_DataForArrayConstraintsFromSetPurchase_Order_Line_Worktags_Data($purchase_Order_Line_Worktags_Data))) {
            throw new \InvalidArgumentException($purchase_Order_Line_Worktags_DataArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Line_Worktags_Data = $purchase_Order_Line_Worktags_Data;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Line_Worktags_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Oder_Line_Worktags_DataType $item
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function addToPurchase_Order_Line_Worktags_Data(\StructType\Purchase_Oder_Line_Worktags_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Oder_Line_Worktags_DataType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Line_Worktags_Data property can only contain items of type \StructType\Purchase_Oder_Line_Worktags_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Line_Worktags_Data[] = $item;
        return $this;
    }
    /**
     * Get ISO8601_Requested_Delivery_Date value
     * @return string|null
     */
    public function getISO8601_Requested_Delivery_Date()
    {
        return $this->ISO8601_Requested_Delivery_Date;
    }
    /**
     * Set ISO8601_Requested_Delivery_Date value
     * @param string $iSO8601_Requested_Delivery_Date
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setISO8601_Requested_Delivery_Date($iSO8601_Requested_Delivery_Date = null)
    {
        // validation for constraint: string
        if (!is_null($iSO8601_Requested_Delivery_Date) && !is_string($iSO8601_Requested_Delivery_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iSO8601_Requested_Delivery_Date, true), gettype($iSO8601_Requested_Delivery_Date)), __LINE__);
        }
        $this->ISO8601_Requested_Delivery_Date = $iSO8601_Requested_Delivery_Date;
        return $this;
    }
}
