<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Portfolio_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Project Portfolio Request Criteria
 * @subpackage Structs
 */
class Project_Portfolio_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: This is a unique identifier for Project Portfolio.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Project_Portfolio_Name
     * Meta information extracted from the WSDL
     * - documentation: Free form text for a meaningful Project Portfolio Name. Project Portfolio Name must be unique.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Portfolio_Name;
    /**
     * The Parent_Portfolio_Reference
     * Meta information extracted from the WSDL
     * - documentation: The parent of this project portfolio.
     * - minOccurs: 0
     * @var \StructType\Project_PortfolioObjectType
     */
    public $Parent_Portfolio_Reference;
    /**
     * Constructor method for Project_Portfolio_Request_CriteriaType
     * @uses Project_Portfolio_Request_CriteriaType::setID()
     * @uses Project_Portfolio_Request_CriteriaType::setProject_Portfolio_Name()
     * @uses Project_Portfolio_Request_CriteriaType::setParent_Portfolio_Reference()
     * @param string $iD
     * @param string $project_Portfolio_Name
     * @param \StructType\Project_PortfolioObjectType $parent_Portfolio_Reference
     */
    public function __construct($iD = null, $project_Portfolio_Name = null, \StructType\Project_PortfolioObjectType $parent_Portfolio_Reference = null)
    {
        $this
            ->setID($iD)
            ->setProject_Portfolio_Name($project_Portfolio_Name)
            ->setParent_Portfolio_Reference($parent_Portfolio_Reference);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Project_Portfolio_Request_CriteriaType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Project_Portfolio_Name value
     * @return string|null
     */
    public function getProject_Portfolio_Name()
    {
        return $this->Project_Portfolio_Name;
    }
    /**
     * Set Project_Portfolio_Name value
     * @param string $project_Portfolio_Name
     * @return \StructType\Project_Portfolio_Request_CriteriaType
     */
    public function setProject_Portfolio_Name($project_Portfolio_Name = null)
    {
        // validation for constraint: string
        if (!is_null($project_Portfolio_Name) && !is_string($project_Portfolio_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Portfolio_Name, true), gettype($project_Portfolio_Name)), __LINE__);
        }
        $this->Project_Portfolio_Name = $project_Portfolio_Name;
        return $this;
    }
    /**
     * Get Parent_Portfolio_Reference value
     * @return \StructType\Project_PortfolioObjectType|null
     */
    public function getParent_Portfolio_Reference()
    {
        return $this->Parent_Portfolio_Reference;
    }
    /**
     * Set Parent_Portfolio_Reference value
     * @param \StructType\Project_PortfolioObjectType $parent_Portfolio_Reference
     * @return \StructType\Project_Portfolio_Request_CriteriaType
     */
    public function setParent_Portfolio_Reference(\StructType\Project_PortfolioObjectType $parent_Portfolio_Reference = null)
    {
        $this->Parent_Portfolio_Reference = $parent_Portfolio_Reference;
        return $this;
    }
}
