<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payroll_Timesheet_Day_Total_Hours_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The date for the day on a Timesheet Line must be unique to other dates on the same Timesheet Line. | This element encapsulates data for a single Payroll Timesheet Day. It contains the date of the day being tracked, and the total
 * hours worked.
 * @subpackage Structs
 */
class Payroll_Timesheet_Day_Total_Hours_DataType extends AbstractStructBase
{
    /**
     * The Timesheet_Day_Date
     * Meta information extracted from the WSDL
     * - documentation: The date for the day on the timesheet must be within the date range of the Period selected. | The date this day contains hours for.
     * - maxOccurs: 1
     * @var string
     */
    public $Timesheet_Day_Date;
    /**
     * The Hours_Worked
     * Meta information extracted from the WSDL
     * - documentation: The amount of hours worked for the time card line specified for Get_Timesheet operation's response. | The total hours worked on this day.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 14
     * @var float
     */
    public $Hours_Worked;
    /**
     * Constructor method for Payroll_Timesheet_Day_Total_Hours_DataType
     * @uses Payroll_Timesheet_Day_Total_Hours_DataType::setTimesheet_Day_Date()
     * @uses Payroll_Timesheet_Day_Total_Hours_DataType::setHours_Worked()
     * @param string $timesheet_Day_Date
     * @param float $hours_Worked
     */
    public function __construct($timesheet_Day_Date = null, $hours_Worked = null)
    {
        $this
            ->setTimesheet_Day_Date($timesheet_Day_Date)
            ->setHours_Worked($hours_Worked);
    }
    /**
     * Get Timesheet_Day_Date value
     * @return string|null
     */
    public function getTimesheet_Day_Date()
    {
        return $this->Timesheet_Day_Date;
    }
    /**
     * Set Timesheet_Day_Date value
     * @param string $timesheet_Day_Date
     * @return \StructType\Payroll_Timesheet_Day_Total_Hours_DataType
     */
    public function setTimesheet_Day_Date($timesheet_Day_Date = null)
    {
        // validation for constraint: string
        if (!is_null($timesheet_Day_Date) && !is_string($timesheet_Day_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timesheet_Day_Date, true), gettype($timesheet_Day_Date)), __LINE__);
        }
        $this->Timesheet_Day_Date = $timesheet_Day_Date;
        return $this;
    }
    /**
     * Get Hours_Worked value
     * @return float|null
     */
    public function getHours_Worked()
    {
        return $this->Hours_Worked;
    }
    /**
     * Set Hours_Worked value
     * @param float $hours_Worked
     * @return \StructType\Payroll_Timesheet_Day_Total_Hours_DataType
     */
    public function setHours_Worked($hours_Worked = null)
    {
        // validation for constraint: float
        if (!is_null($hours_Worked) && !(is_float($hours_Worked) || is_numeric($hours_Worked))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hours_Worked, true), gettype($hours_Worked)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($hours_Worked) && mb_strlen(mb_substr($hours_Worked, false !== mb_strpos($hours_Worked, '.') ? mb_strpos($hours_Worked, '.') + 1 : mb_strlen($hours_Worked))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($hours_Worked, true), mb_strlen(mb_substr($hours_Worked, mb_strpos($hours_Worked, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(14)
        if (!is_null($hours_Worked) && mb_strlen(preg_replace('/(\D)/', '', $hours_Worked)) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 14 digits, "%d" given', var_export($hours_Worked, true), mb_strlen(preg_replace('/(\D)/', '', $hours_Worked))), __LINE__);
        }
        $this->Hours_Worked = $hours_Worked;
        return $this;
    }
}
