<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Import_Resource_Forecast_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Web service is set to AddOnly false, cannot create a new Resource Forecast. | The Web Service is set to Add Only; documents cannot be resubmitted. | This element is starting element for Import Resource Forecast High Volume Web
 * Service.
 * @subpackage Structs
 */
class Import_Resource_Forecast_RequestType extends AbstractStructBase
{
    /**
     * The Resource_Forecast_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resource Forecast Reference
     * - minOccurs: 0
     * @var \StructType\Resource_ForecastObjectType
     */
    public $Resource_Forecast_Reference;
    /**
     * The Resource_Forecast_Data
     * Meta information extracted from the WSDL
     * - documentation: Resource Forecast Header Data
     * @var \StructType\Resource_Forecast__HV__DataType
     */
    public $Resource_Forecast_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only flag
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Import_Resource_Forecast_RequestType
     * @uses Import_Resource_Forecast_RequestType::setResource_Forecast_Reference()
     * @uses Import_Resource_Forecast_RequestType::setResource_Forecast_Data()
     * @uses Import_Resource_Forecast_RequestType::setAdd_Only()
     * @uses Import_Resource_Forecast_RequestType::setVersion()
     * @param \StructType\Resource_ForecastObjectType $resource_Forecast_Reference
     * @param \StructType\Resource_Forecast__HV__DataType $resource_Forecast_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Resource_ForecastObjectType $resource_Forecast_Reference = null, \StructType\Resource_Forecast__HV__DataType $resource_Forecast_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setResource_Forecast_Reference($resource_Forecast_Reference)
            ->setResource_Forecast_Data($resource_Forecast_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Resource_Forecast_Reference value
     * @return \StructType\Resource_ForecastObjectType|null
     */
    public function getResource_Forecast_Reference()
    {
        return $this->Resource_Forecast_Reference;
    }
    /**
     * Set Resource_Forecast_Reference value
     * @param \StructType\Resource_ForecastObjectType $resource_Forecast_Reference
     * @return \StructType\Import_Resource_Forecast_RequestType
     */
    public function setResource_Forecast_Reference(\StructType\Resource_ForecastObjectType $resource_Forecast_Reference = null)
    {
        $this->Resource_Forecast_Reference = $resource_Forecast_Reference;
        return $this;
    }
    /**
     * Get Resource_Forecast_Data value
     * @return \StructType\Resource_Forecast__HV__DataType|null
     */
    public function getResource_Forecast_Data()
    {
        return $this->Resource_Forecast_Data;
    }
    /**
     * Set Resource_Forecast_Data value
     * @param \StructType\Resource_Forecast__HV__DataType $resource_Forecast_Data
     * @return \StructType\Import_Resource_Forecast_RequestType
     */
    public function setResource_Forecast_Data(\StructType\Resource_Forecast__HV__DataType $resource_Forecast_Data = null)
    {
        $this->Resource_Forecast_Data = $resource_Forecast_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Import_Resource_Forecast_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Import_Resource_Forecast_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
