<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element used to Request certain Suppliers
 * @subpackage Structs
 */
class Supplier_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Updated_From_Date
     * Meta information extracted from the WSDL
     * - documentation: Supplier Change From Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Updated_From_Date;
    /**
     * The Updated_To_Date
     * Meta information extracted from the WSDL
     * - documentation: Supplier Change To Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Updated_To_Date;
    /**
     * The Supplier_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Status
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Entity_Status_ValueObjectType[]
     */
    public $Supplier_Status_Reference;
    /**
     * The Supplier_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Category
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_CategoryObjectType[]
     */
    public $Supplier_Category_Reference;
    /**
     * The Supplier_Group_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Group
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_GroupObjectType[]
     */
    public $Supplier_Group_Reference;
    /**
     * The Customer_Account_Number
     * Meta information extracted from the WSDL
     * - documentation: Account Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Customer_Account_Number;
    /**
     * The DUNS_Number
     * Meta information extracted from the WSDL
     * - documentation: DUNS Number that uniquely identifies the Supplier. | DUNS Number
     * - base: xsd:string
     * - maxLength: 9
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DUNS_Number;
    /**
     * The Parent_Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Parent Supplier
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType[]
     */
    public $Parent_Supplier_Reference;
    /**
     * Constructor method for Supplier_Request_CriteriaType
     * @uses Supplier_Request_CriteriaType::setUpdated_From_Date()
     * @uses Supplier_Request_CriteriaType::setUpdated_To_Date()
     * @uses Supplier_Request_CriteriaType::setSupplier_Status_Reference()
     * @uses Supplier_Request_CriteriaType::setSupplier_Category_Reference()
     * @uses Supplier_Request_CriteriaType::setSupplier_Group_Reference()
     * @uses Supplier_Request_CriteriaType::setCustomer_Account_Number()
     * @uses Supplier_Request_CriteriaType::setDUNS_Number()
     * @uses Supplier_Request_CriteriaType::setParent_Supplier_Reference()
     * @param string $updated_From_Date
     * @param string $updated_To_Date
     * @param \StructType\Business_Entity_Status_ValueObjectType[] $supplier_Status_Reference
     * @param \StructType\Supplier_CategoryObjectType[] $supplier_Category_Reference
     * @param \StructType\Supplier_GroupObjectType[] $supplier_Group_Reference
     * @param string $customer_Account_Number
     * @param string $dUNS_Number
     * @param \StructType\SupplierObjectType[] $parent_Supplier_Reference
     */
    public function __construct($updated_From_Date = null, $updated_To_Date = null, array $supplier_Status_Reference = array(), array $supplier_Category_Reference = array(), array $supplier_Group_Reference = array(), $customer_Account_Number = null, $dUNS_Number = null, array $parent_Supplier_Reference = array())
    {
        $this
            ->setUpdated_From_Date($updated_From_Date)
            ->setUpdated_To_Date($updated_To_Date)
            ->setSupplier_Status_Reference($supplier_Status_Reference)
            ->setSupplier_Category_Reference($supplier_Category_Reference)
            ->setSupplier_Group_Reference($supplier_Group_Reference)
            ->setCustomer_Account_Number($customer_Account_Number)
            ->setDUNS_Number($dUNS_Number)
            ->setParent_Supplier_Reference($parent_Supplier_Reference);
    }
    /**
     * Get Updated_From_Date value
     * @return string|null
     */
    public function getUpdated_From_Date()
    {
        return $this->Updated_From_Date;
    }
    /**
     * Set Updated_From_Date value
     * @param string $updated_From_Date
     * @return \StructType\Supplier_Request_CriteriaType
     */
    public function setUpdated_From_Date($updated_From_Date = null)
    {
        // validation for constraint: string
        if (!is_null($updated_From_Date) && !is_string($updated_From_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updated_From_Date, true), gettype($updated_From_Date)), __LINE__);
        }
        $this->Updated_From_Date = $updated_From_Date;
        return $this;
    }
    /**
     * Get Updated_To_Date value
     * @return string|null
     */
    public function getUpdated_To_Date()
    {
        return $this->Updated_To_Date;
    }
    /**
     * Set Updated_To_Date value
     * @param string $updated_To_Date
     * @return \StructType\Supplier_Request_CriteriaType
     */
    public function setUpdated_To_Date($updated_To_Date = null)
    {
        // validation for constraint: string
        if (!is_null($updated_To_Date) && !is_string($updated_To_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updated_To_Date, true), gettype($updated_To_Date)), __LINE__);
        }
        $this->Updated_To_Date = $updated_To_Date;
        return $this;
    }
    /**
     * Get Supplier_Status_Reference value
     * @return \StructType\Business_Entity_Status_ValueObjectType[]|null
     */
    public function getSupplier_Status_Reference()
    {
        return $this->Supplier_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Status_ReferenceForArrayConstraintsFromSetSupplier_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Request_CriteriaTypeSupplier_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Request_CriteriaTypeSupplier_Status_ReferenceItem instanceof \StructType\Business_Entity_Status_ValueObjectType) {
                $invalidValues[] = is_object($supplier_Request_CriteriaTypeSupplier_Status_ReferenceItem) ? get_class($supplier_Request_CriteriaTypeSupplier_Status_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Request_CriteriaTypeSupplier_Status_ReferenceItem), var_export($supplier_Request_CriteriaTypeSupplier_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Status_Reference property can only contain items of type \StructType\Business_Entity_Status_ValueObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Entity_Status_ValueObjectType[] $supplier_Status_Reference
     * @return \StructType\Supplier_Request_CriteriaType
     */
    public function setSupplier_Status_Reference(array $supplier_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Status_ReferenceArrayErrorMessage = self::validateSupplier_Status_ReferenceForArrayConstraintsFromSetSupplier_Status_Reference($supplier_Status_Reference))) {
            throw new \InvalidArgumentException($supplier_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Status_Reference = $supplier_Status_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Entity_Status_ValueObjectType $item
     * @return \StructType\Supplier_Request_CriteriaType
     */
    public function addToSupplier_Status_Reference(\StructType\Business_Entity_Status_ValueObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Entity_Status_ValueObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Status_Reference property can only contain items of type \StructType\Business_Entity_Status_ValueObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Category_Reference value
     * @return \StructType\Supplier_CategoryObjectType[]|null
     */
    public function getSupplier_Category_Reference()
    {
        return $this->Supplier_Category_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Category_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Category_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Category_ReferenceForArrayConstraintsFromSetSupplier_Category_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Request_CriteriaTypeSupplier_Category_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Request_CriteriaTypeSupplier_Category_ReferenceItem instanceof \StructType\Supplier_CategoryObjectType) {
                $invalidValues[] = is_object($supplier_Request_CriteriaTypeSupplier_Category_ReferenceItem) ? get_class($supplier_Request_CriteriaTypeSupplier_Category_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Request_CriteriaTypeSupplier_Category_ReferenceItem), var_export($supplier_Request_CriteriaTypeSupplier_Category_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Category_Reference property can only contain items of type \StructType\Supplier_CategoryObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_CategoryObjectType[] $supplier_Category_Reference
     * @return \StructType\Supplier_Request_CriteriaType
     */
    public function setSupplier_Category_Reference(array $supplier_Category_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Category_ReferenceArrayErrorMessage = self::validateSupplier_Category_ReferenceForArrayConstraintsFromSetSupplier_Category_Reference($supplier_Category_Reference))) {
            throw new \InvalidArgumentException($supplier_Category_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Category_Reference = $supplier_Category_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_CategoryObjectType $item
     * @return \StructType\Supplier_Request_CriteriaType
     */
    public function addToSupplier_Category_Reference(\StructType\Supplier_CategoryObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_CategoryObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Category_Reference property can only contain items of type \StructType\Supplier_CategoryObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Category_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Group_Reference value
     * @return \StructType\Supplier_GroupObjectType[]|null
     */
    public function getSupplier_Group_Reference()
    {
        return $this->Supplier_Group_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Group_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Group_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Group_ReferenceForArrayConstraintsFromSetSupplier_Group_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Request_CriteriaTypeSupplier_Group_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Request_CriteriaTypeSupplier_Group_ReferenceItem instanceof \StructType\Supplier_GroupObjectType) {
                $invalidValues[] = is_object($supplier_Request_CriteriaTypeSupplier_Group_ReferenceItem) ? get_class($supplier_Request_CriteriaTypeSupplier_Group_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Request_CriteriaTypeSupplier_Group_ReferenceItem), var_export($supplier_Request_CriteriaTypeSupplier_Group_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Group_Reference property can only contain items of type \StructType\Supplier_GroupObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_GroupObjectType[] $supplier_Group_Reference
     * @return \StructType\Supplier_Request_CriteriaType
     */
    public function setSupplier_Group_Reference(array $supplier_Group_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Group_ReferenceArrayErrorMessage = self::validateSupplier_Group_ReferenceForArrayConstraintsFromSetSupplier_Group_Reference($supplier_Group_Reference))) {
            throw new \InvalidArgumentException($supplier_Group_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Group_Reference = $supplier_Group_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_GroupObjectType $item
     * @return \StructType\Supplier_Request_CriteriaType
     */
    public function addToSupplier_Group_Reference(\StructType\Supplier_GroupObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_GroupObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Group_Reference property can only contain items of type \StructType\Supplier_GroupObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Group_Reference[] = $item;
        return $this;
    }
    /**
     * Get Customer_Account_Number value
     * @return string|null
     */
    public function getCustomer_Account_Number()
    {
        return $this->Customer_Account_Number;
    }
    /**
     * Set Customer_Account_Number value
     * @param string $customer_Account_Number
     * @return \StructType\Supplier_Request_CriteriaType
     */
    public function setCustomer_Account_Number($customer_Account_Number = null)
    {
        // validation for constraint: string
        if (!is_null($customer_Account_Number) && !is_string($customer_Account_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customer_Account_Number, true), gettype($customer_Account_Number)), __LINE__);
        }
        $this->Customer_Account_Number = $customer_Account_Number;
        return $this;
    }
    /**
     * Get DUNS_Number value
     * @return string|null
     */
    public function getDUNS_Number()
    {
        return $this->DUNS_Number;
    }
    /**
     * Set DUNS_Number value
     * @param string $dUNS_Number
     * @return \StructType\Supplier_Request_CriteriaType
     */
    public function setDUNS_Number($dUNS_Number = null)
    {
        // validation for constraint: string
        if (!is_null($dUNS_Number) && !is_string($dUNS_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dUNS_Number, true), gettype($dUNS_Number)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($dUNS_Number) && mb_strlen($dUNS_Number) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen($dUNS_Number)), __LINE__);
        }
        $this->DUNS_Number = $dUNS_Number;
        return $this;
    }
    /**
     * Get Parent_Supplier_Reference value
     * @return \StructType\SupplierObjectType[]|null
     */
    public function getParent_Supplier_Reference()
    {
        return $this->Parent_Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setParent_Supplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParent_Supplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParent_Supplier_ReferenceForArrayConstraintsFromSetParent_Supplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Request_CriteriaTypeParent_Supplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Request_CriteriaTypeParent_Supplier_ReferenceItem instanceof \StructType\SupplierObjectType) {
                $invalidValues[] = is_object($supplier_Request_CriteriaTypeParent_Supplier_ReferenceItem) ? get_class($supplier_Request_CriteriaTypeParent_Supplier_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Request_CriteriaTypeParent_Supplier_ReferenceItem), var_export($supplier_Request_CriteriaTypeParent_Supplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Parent_Supplier_Reference property can only contain items of type \StructType\SupplierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Parent_Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType[] $parent_Supplier_Reference
     * @return \StructType\Supplier_Request_CriteriaType
     */
    public function setParent_Supplier_Reference(array $parent_Supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($parent_Supplier_ReferenceArrayErrorMessage = self::validateParent_Supplier_ReferenceForArrayConstraintsFromSetParent_Supplier_Reference($parent_Supplier_Reference))) {
            throw new \InvalidArgumentException($parent_Supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Parent_Supplier_Reference = $parent_Supplier_Reference;
        return $this;
    }
    /**
     * Add item to Parent_Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType $item
     * @return \StructType\Supplier_Request_CriteriaType
     */
    public function addToParent_Supplier_Reference(\StructType\SupplierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Parent_Supplier_Reference property can only contain items of type \StructType\SupplierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Parent_Supplier_Reference[] = $item;
        return $this;
    }
}
