<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Work_Queue_Tag_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all supplier invoice work queue tag data
 * @subpackage Structs
 */
class Supplier_Invoice_Work_Queue_Tag_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: The supplier invoice work queue tag unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: The name for the supplier invoice work queue tag
     * - maxOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: The description for the supplier invoice work queue tag
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Urgent
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate if the supplier invoice work queue tag should appear at the top of the supplier invoice work queue
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Urgent;
    /**
     * The Retain_Tag
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate if the supplier invoice work queue tag is going to be retained
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Retain_Tag;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate if the supplier invoice work queue tag is inactive
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * Constructor method for Supplier_Invoice_Work_Queue_Tag_DataType
     * @uses Supplier_Invoice_Work_Queue_Tag_DataType::setID()
     * @uses Supplier_Invoice_Work_Queue_Tag_DataType::setName()
     * @uses Supplier_Invoice_Work_Queue_Tag_DataType::setDescription()
     * @uses Supplier_Invoice_Work_Queue_Tag_DataType::setUrgent()
     * @uses Supplier_Invoice_Work_Queue_Tag_DataType::setRetain_Tag()
     * @uses Supplier_Invoice_Work_Queue_Tag_DataType::setInactive()
     * @param string $iD
     * @param string $name
     * @param string $description
     * @param bool $urgent
     * @param bool $retain_Tag
     * @param bool $inactive
     */
    public function __construct($iD = null, $name = null, $description = null, $urgent = null, $retain_Tag = null, $inactive = null)
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setDescription($description)
            ->setUrgent($urgent)
            ->setRetain_Tag($retain_Tag)
            ->setInactive($inactive);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_DataType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Urgent value
     * @return bool|null
     */
    public function getUrgent()
    {
        return $this->Urgent;
    }
    /**
     * Set Urgent value
     * @param bool $urgent
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_DataType
     */
    public function setUrgent($urgent = null)
    {
        // validation for constraint: boolean
        if (!is_null($urgent) && !is_bool($urgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($urgent, true), gettype($urgent)), __LINE__);
        }
        $this->Urgent = $urgent;
        return $this;
    }
    /**
     * Get Retain_Tag value
     * @return bool|null
     */
    public function getRetain_Tag()
    {
        return $this->Retain_Tag;
    }
    /**
     * Set Retain_Tag value
     * @param bool $retain_Tag
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_DataType
     */
    public function setRetain_Tag($retain_Tag = null)
    {
        // validation for constraint: boolean
        if (!is_null($retain_Tag) && !is_bool($retain_Tag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retain_Tag, true), gettype($retain_Tag)), __LINE__);
        }
        $this->Retain_Tag = $retain_Tag;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
}
