<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Item_Request_Template_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Purchase Item Request Template Data
 * @subpackage Structs
 */
class Purchase_Item_Request_Template_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Item_Request_Template_ID
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item Request Template ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Purchase_Item_Request_Template_ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item Request Template Name
     * - maxOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: Comment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The Purchase_Item_Request_Template_Definition_Data
     * Meta information extracted from the WSDL
     * - documentation: Worksheet Template Definition Data
     * - maxOccurs: unbounded
     * @var \StructType\Purchase_Item_Request_Template_Definition_DataType[]
     */
    public $Purchase_Item_Request_Template_Definition_Data;
    /**
     * Constructor method for Purchase_Item_Request_Template_DataType
     * @uses Purchase_Item_Request_Template_DataType::setPurchase_Item_Request_Template_ID()
     * @uses Purchase_Item_Request_Template_DataType::setName()
     * @uses Purchase_Item_Request_Template_DataType::setComment()
     * @uses Purchase_Item_Request_Template_DataType::setPurchase_Item_Request_Template_Definition_Data()
     * @param string $purchase_Item_Request_Template_ID
     * @param string $name
     * @param string $comment
     * @param \StructType\Purchase_Item_Request_Template_Definition_DataType[] $purchase_Item_Request_Template_Definition_Data
     */
    public function __construct($purchase_Item_Request_Template_ID = null, $name = null, $comment = null, array $purchase_Item_Request_Template_Definition_Data = array())
    {
        $this
            ->setPurchase_Item_Request_Template_ID($purchase_Item_Request_Template_ID)
            ->setName($name)
            ->setComment($comment)
            ->setPurchase_Item_Request_Template_Definition_Data($purchase_Item_Request_Template_Definition_Data);
    }
    /**
     * Get Purchase_Item_Request_Template_ID value
     * @return string|null
     */
    public function getPurchase_Item_Request_Template_ID()
    {
        return $this->Purchase_Item_Request_Template_ID;
    }
    /**
     * Set Purchase_Item_Request_Template_ID value
     * @param string $purchase_Item_Request_Template_ID
     * @return \StructType\Purchase_Item_Request_Template_DataType
     */
    public function setPurchase_Item_Request_Template_ID($purchase_Item_Request_Template_ID = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Item_Request_Template_ID) && !is_string($purchase_Item_Request_Template_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Item_Request_Template_ID, true), gettype($purchase_Item_Request_Template_ID)), __LINE__);
        }
        $this->Purchase_Item_Request_Template_ID = $purchase_Item_Request_Template_ID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Purchase_Item_Request_Template_DataType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Purchase_Item_Request_Template_DataType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get Purchase_Item_Request_Template_Definition_Data value
     * @return \StructType\Purchase_Item_Request_Template_Definition_DataType[]|null
     */
    public function getPurchase_Item_Request_Template_Definition_Data()
    {
        return $this->Purchase_Item_Request_Template_Definition_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Item_Request_Template_Definition_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Item_Request_Template_Definition_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Item_Request_Template_Definition_DataForArrayConstraintsFromSetPurchase_Item_Request_Template_Definition_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_Request_Template_DataTypePurchase_Item_Request_Template_Definition_DataItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_Request_Template_DataTypePurchase_Item_Request_Template_Definition_DataItem instanceof \StructType\Purchase_Item_Request_Template_Definition_DataType) {
                $invalidValues[] = is_object($purchase_Item_Request_Template_DataTypePurchase_Item_Request_Template_Definition_DataItem) ? get_class($purchase_Item_Request_Template_DataTypePurchase_Item_Request_Template_Definition_DataItem) : sprintf('%s(%s)', gettype($purchase_Item_Request_Template_DataTypePurchase_Item_Request_Template_Definition_DataItem), var_export($purchase_Item_Request_Template_DataTypePurchase_Item_Request_Template_Definition_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Item_Request_Template_Definition_Data property can only contain items of type \StructType\Purchase_Item_Request_Template_Definition_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Item_Request_Template_Definition_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_Request_Template_Definition_DataType[] $purchase_Item_Request_Template_Definition_Data
     * @return \StructType\Purchase_Item_Request_Template_DataType
     */
    public function setPurchase_Item_Request_Template_Definition_Data(array $purchase_Item_Request_Template_Definition_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Item_Request_Template_Definition_DataArrayErrorMessage = self::validatePurchase_Item_Request_Template_Definition_DataForArrayConstraintsFromSetPurchase_Item_Request_Template_Definition_Data($purchase_Item_Request_Template_Definition_Data))) {
            throw new \InvalidArgumentException($purchase_Item_Request_Template_Definition_DataArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Item_Request_Template_Definition_Data = $purchase_Item_Request_Template_Definition_Data;
        return $this;
    }
    /**
     * Add item to Purchase_Item_Request_Template_Definition_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_Request_Template_Definition_DataType $item
     * @return \StructType\Purchase_Item_Request_Template_DataType
     */
    public function addToPurchase_Item_Request_Template_Definition_Data(\StructType\Purchase_Item_Request_Template_Definition_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Item_Request_Template_Definition_DataType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Item_Request_Template_Definition_Data property can only contain items of type \StructType\Purchase_Item_Request_Template_Definition_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Item_Request_Template_Definition_Data[] = $item;
        return $this;
    }
}
