<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for External_Business_Entity_Contact_Request_CriteriaType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing External Business Entity Contact request criteria.
 * @subpackage Structs
 */
class External_Business_Entity_Contact_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType[]
     */
    public $Supplier_Reference;
    /**
     * Constructor method for External_Business_Entity_Contact_Request_CriteriaType
     * @uses External_Business_Entity_Contact_Request_CriteriaType::setSupplier_Reference()
     * @param \StructType\SupplierObjectType[] $supplier_Reference
     */
    public function __construct(array $supplier_Reference = array())
    {
        $this
            ->setSupplier_Reference($supplier_Reference);
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $external_Business_Entity_Contact_Request_CriteriaTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$external_Business_Entity_Contact_Request_CriteriaTypeSupplier_ReferenceItem instanceof \StructType\SupplierObjectType) {
                $invalidValues[] = is_object($external_Business_Entity_Contact_Request_CriteriaTypeSupplier_ReferenceItem) ? get_class($external_Business_Entity_Contact_Request_CriteriaTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($external_Business_Entity_Contact_Request_CriteriaTypeSupplier_ReferenceItem), var_export($external_Business_Entity_Contact_Request_CriteriaTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\SupplierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType[] $supplier_Reference
     * @return \StructType\External_Business_Entity_Contact_Request_CriteriaType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType $item
     * @return \StructType\External_Business_Entity_Contact_Request_CriteriaType
     */
    public function addToSupplier_Reference(\StructType\SupplierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\SupplierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
}
