<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Report_WWSType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element that includes expense report instance and data
 * @subpackage Structs
 */
class Expense_Report_WWSType extends AbstractStructBase
{
    /**
     * The Expense_Report_Reference
     * Meta information extracted from the WSDL
     * - documentation: Expense Report Reference
     * - minOccurs: 0
     * @var \StructType\Expense_ReportObjectType
     */
    public $Expense_Report_Reference;
    /**
     * The Expense_Report_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that encapsulates all the data related to the expense report.
     * - minOccurs: 0
     * @var \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public $Expense_Report_Data;
    /**
     * The Expense_Report_Credit_Card_Transactions_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Expense_Report_Credit_Card_Transactions_DataType
     */
    public $Expense_Report_Credit_Card_Transactions_Data;
    /**
     * Constructor method for Expense_Report_WWSType
     * @uses Expense_Report_WWSType::setExpense_Report_Reference()
     * @uses Expense_Report_WWSType::setExpense_Report_Data()
     * @uses Expense_Report_WWSType::setExpense_Report_Credit_Card_Transactions_Data()
     * @param \StructType\Expense_ReportObjectType $expense_Report_Reference
     * @param \StructType\Expense_Report_WWS_Outbound_DataType $expense_Report_Data
     * @param \StructType\Expense_Report_Credit_Card_Transactions_DataType $expense_Report_Credit_Card_Transactions_Data
     */
    public function __construct(\StructType\Expense_ReportObjectType $expense_Report_Reference = null, \StructType\Expense_Report_WWS_Outbound_DataType $expense_Report_Data = null, \StructType\Expense_Report_Credit_Card_Transactions_DataType $expense_Report_Credit_Card_Transactions_Data = null)
    {
        $this
            ->setExpense_Report_Reference($expense_Report_Reference)
            ->setExpense_Report_Data($expense_Report_Data)
            ->setExpense_Report_Credit_Card_Transactions_Data($expense_Report_Credit_Card_Transactions_Data);
    }
    /**
     * Get Expense_Report_Reference value
     * @return \StructType\Expense_ReportObjectType|null
     */
    public function getExpense_Report_Reference()
    {
        return $this->Expense_Report_Reference;
    }
    /**
     * Set Expense_Report_Reference value
     * @param \StructType\Expense_ReportObjectType $expense_Report_Reference
     * @return \StructType\Expense_Report_WWSType
     */
    public function setExpense_Report_Reference(\StructType\Expense_ReportObjectType $expense_Report_Reference = null)
    {
        $this->Expense_Report_Reference = $expense_Report_Reference;
        return $this;
    }
    /**
     * Get Expense_Report_Data value
     * @return \StructType\Expense_Report_WWS_Outbound_DataType|null
     */
    public function getExpense_Report_Data()
    {
        return $this->Expense_Report_Data;
    }
    /**
     * Set Expense_Report_Data value
     * @param \StructType\Expense_Report_WWS_Outbound_DataType $expense_Report_Data
     * @return \StructType\Expense_Report_WWSType
     */
    public function setExpense_Report_Data(\StructType\Expense_Report_WWS_Outbound_DataType $expense_Report_Data = null)
    {
        $this->Expense_Report_Data = $expense_Report_Data;
        return $this;
    }
    /**
     * Get Expense_Report_Credit_Card_Transactions_Data value
     * @return \StructType\Expense_Report_Credit_Card_Transactions_DataType|null
     */
    public function getExpense_Report_Credit_Card_Transactions_Data()
    {
        return $this->Expense_Report_Credit_Card_Transactions_Data;
    }
    /**
     * Set Expense_Report_Credit_Card_Transactions_Data value
     * @param \StructType\Expense_Report_Credit_Card_Transactions_DataType $expense_Report_Credit_Card_Transactions_Data
     * @return \StructType\Expense_Report_WWSType
     */
    public function setExpense_Report_Credit_Card_Transactions_Data(\StructType\Expense_Report_Credit_Card_Transactions_DataType $expense_Report_Credit_Card_Transactions_Data = null)
    {
        $this->Expense_Report_Credit_Card_Transactions_Data = $expense_Report_Credit_Card_Transactions_Data;
        return $this;
    }
}
