<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Customer wrapper element that contains the Supplier data elements that are included in the response as requested by the references, criteria and grouping
 * @subpackage Structs
 */
class Supplier_Response_DataType extends AbstractStructBase
{
    /**
     * The Supplier
     * Meta information extracted from the WSDL
     * - documentation: Supplier wrapper element that contains the Supplier "Data" elements that are included in the response
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SupplierType[]
     */
    public $Supplier;
    /**
     * Constructor method for Supplier_Response_DataType
     * @uses Supplier_Response_DataType::setSupplier()
     * @param \StructType\SupplierType[] $supplier
     */
    public function __construct(array $supplier = array())
    {
        $this
            ->setSupplier($supplier);
    }
    /**
     * Get Supplier value
     * @return \StructType\SupplierType[]|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplierForArrayConstraintsFromSetSupplier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Response_DataTypeSupplierItem) {
            // validation for constraint: itemType
            if (!$supplier_Response_DataTypeSupplierItem instanceof \StructType\SupplierType) {
                $invalidValues[] = is_object($supplier_Response_DataTypeSupplierItem) ? get_class($supplier_Response_DataTypeSupplierItem) : sprintf('%s(%s)', gettype($supplier_Response_DataTypeSupplierItem), var_export($supplier_Response_DataTypeSupplierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier property can only contain items of type \StructType\SupplierType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierType[] $supplier
     * @return \StructType\Supplier_Response_DataType
     */
    public function setSupplier(array $supplier = array())
    {
        // validation for constraint: array
        if ('' !== ($supplierArrayErrorMessage = self::validateSupplierForArrayConstraintsFromSetSupplier($supplier))) {
            throw new \InvalidArgumentException($supplierArrayErrorMessage, __LINE__);
        }
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Add item to Supplier value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierType $item
     * @return \StructType\Supplier_Response_DataType
     */
    public function addToSupplier(\StructType\SupplierType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierType) {
            throw new \InvalidArgumentException(sprintf('The Supplier property can only contain items of type \StructType\SupplierType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier[] = $item;
        return $this;
    }
}
