<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Remove_Asset_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data used to process the asset removal.
 * @subpackage Structs
 */
class Remove_Asset_DataType extends AbstractStructBase
{
    /**
     * The Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: Asset cannot be removed when referencing invalid supplier invoice lines. | An asset can only be removed if its events are limited to issue and transfer, and it was either manually registered or registered from a Receipt or Supplier
     * Invoice that is now canceled. If registered from a lease type Supplier Contract the contract must be canceled. Assets that are Discrete Composite Asset or Components of Non-Discrete Composite Asset cannot be removed. | A reference to the asset that
     * should be removed.
     * @var \StructType\Business_AssetObjectType
     */
    public $Asset_Reference;
    /**
     * The Transaction_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: The transaction effective date for the asset removal.
     * - maxOccurs: 1
     * @var string
     */
    public $Transaction_Effective_Date;
    /**
     * The Asset_Removal_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the removal reason for the asset.
     * @var \StructType\Asset_Removal_ReasonObjectType
     */
    public $Asset_Removal_Reason_Reference;
    /**
     * The Asset_Removal_Comments
     * Meta information extracted from the WSDL
     * - documentation: Free-form comments to include with the removal event.
     * - maxOccurs: 1
     * @var string
     */
    public $Asset_Removal_Comments;
    /**
     * Constructor method for Remove_Asset_DataType
     * @uses Remove_Asset_DataType::setAsset_Reference()
     * @uses Remove_Asset_DataType::setTransaction_Effective_Date()
     * @uses Remove_Asset_DataType::setAsset_Removal_Reason_Reference()
     * @uses Remove_Asset_DataType::setAsset_Removal_Comments()
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @param string $transaction_Effective_Date
     * @param \StructType\Asset_Removal_ReasonObjectType $asset_Removal_Reason_Reference
     * @param string $asset_Removal_Comments
     */
    public function __construct(\StructType\Business_AssetObjectType $asset_Reference = null, $transaction_Effective_Date = null, \StructType\Asset_Removal_ReasonObjectType $asset_Removal_Reason_Reference = null, $asset_Removal_Comments = null)
    {
        $this
            ->setAsset_Reference($asset_Reference)
            ->setTransaction_Effective_Date($transaction_Effective_Date)
            ->setAsset_Removal_Reason_Reference($asset_Removal_Reason_Reference)
            ->setAsset_Removal_Comments($asset_Removal_Comments);
    }
    /**
     * Get Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getAsset_Reference()
    {
        return $this->Asset_Reference;
    }
    /**
     * Set Asset_Reference value
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @return \StructType\Remove_Asset_DataType
     */
    public function setAsset_Reference(\StructType\Business_AssetObjectType $asset_Reference = null)
    {
        $this->Asset_Reference = $asset_Reference;
        return $this;
    }
    /**
     * Get Transaction_Effective_Date value
     * @return string|null
     */
    public function getTransaction_Effective_Date()
    {
        return $this->Transaction_Effective_Date;
    }
    /**
     * Set Transaction_Effective_Date value
     * @param string $transaction_Effective_Date
     * @return \StructType\Remove_Asset_DataType
     */
    public function setTransaction_Effective_Date($transaction_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Effective_Date) && !is_string($transaction_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Effective_Date, true), gettype($transaction_Effective_Date)), __LINE__);
        }
        $this->Transaction_Effective_Date = $transaction_Effective_Date;
        return $this;
    }
    /**
     * Get Asset_Removal_Reason_Reference value
     * @return \StructType\Asset_Removal_ReasonObjectType|null
     */
    public function getAsset_Removal_Reason_Reference()
    {
        return $this->Asset_Removal_Reason_Reference;
    }
    /**
     * Set Asset_Removal_Reason_Reference value
     * @param \StructType\Asset_Removal_ReasonObjectType $asset_Removal_Reason_Reference
     * @return \StructType\Remove_Asset_DataType
     */
    public function setAsset_Removal_Reason_Reference(\StructType\Asset_Removal_ReasonObjectType $asset_Removal_Reason_Reference = null)
    {
        $this->Asset_Removal_Reason_Reference = $asset_Removal_Reason_Reference;
        return $this;
    }
    /**
     * Get Asset_Removal_Comments value
     * @return string|null
     */
    public function getAsset_Removal_Comments()
    {
        return $this->Asset_Removal_Comments;
    }
    /**
     * Set Asset_Removal_Comments value
     * @param string $asset_Removal_Comments
     * @return \StructType\Remove_Asset_DataType
     */
    public function setAsset_Removal_Comments($asset_Removal_Comments = null)
    {
        // validation for constraint: string
        if (!is_null($asset_Removal_Comments) && !is_string($asset_Removal_Comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_Removal_Comments, true), gettype($asset_Removal_Comments)), __LINE__);
        }
        $this->Asset_Removal_Comments = $asset_Removal_Comments;
        return $this;
    }
}
