<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Financials_Attachment_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulating element containing all Business Document Attachment data.
 * @subpackage Structs
 */
class Financials_Attachment_WWS_DataType extends AbstractStructBase
{
    /**
     * The File_ID
     * Meta information extracted from the WSDL
     * - documentation: Text attribute identifying a unique ID for Attachment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $File_ID;
    /**
     * The External_Sourceable_ID
     * Meta information extracted from the WSDL
     * - documentation: Attachment ID when object is coming from external source
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_Sourceable_ID;
    /**
     * The File_Content
     * Meta information extracted from the WSDL
     * - documentation: File content in binary format.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $File_Content;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: Comment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The Content_Type
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 80
     * @var string
     */
    public $Content_Type;
    /**
     * The Filename
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * @var string
     */
    public $Filename;
    /**
     * The Encoding
     * Meta information extracted from the WSDL
     * - documentation: Text attribute identifying Encoding of the Attachment.
     * @var string
     */
    public $Encoding;
    /**
     * The Compressed
     * Meta information extracted from the WSDL
     * - documentation: Boolean attribute identifying whether the Attachment is compressed.
     * @var bool
     */
    public $Compressed;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Set this flag to True in order to delete Financial Attachment
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Financials_Attachment_WWS_DataType
     * @uses Financials_Attachment_WWS_DataType::setFile_ID()
     * @uses Financials_Attachment_WWS_DataType::setExternal_Sourceable_ID()
     * @uses Financials_Attachment_WWS_DataType::setFile_Content()
     * @uses Financials_Attachment_WWS_DataType::setComment()
     * @uses Financials_Attachment_WWS_DataType::setContent_Type()
     * @uses Financials_Attachment_WWS_DataType::setFilename()
     * @uses Financials_Attachment_WWS_DataType::setEncoding()
     * @uses Financials_Attachment_WWS_DataType::setCompressed()
     * @uses Financials_Attachment_WWS_DataType::setDelete()
     * @param string $file_ID
     * @param string $external_Sourceable_ID
     * @param string $file_Content
     * @param string $comment
     * @param string $content_Type
     * @param string $filename
     * @param string $encoding
     * @param bool $compressed
     * @param bool $delete
     */
    public function __construct($file_ID = null, $external_Sourceable_ID = null, $file_Content = null, $comment = null, $content_Type = null, $filename = null, $encoding = null, $compressed = null, $delete = null)
    {
        $this
            ->setFile_ID($file_ID)
            ->setExternal_Sourceable_ID($external_Sourceable_ID)
            ->setFile_Content($file_Content)
            ->setComment($comment)
            ->setContent_Type($content_Type)
            ->setFilename($filename)
            ->setEncoding($encoding)
            ->setCompressed($compressed)
            ->setDelete($delete);
    }
    /**
     * Get File_ID value
     * @return string|null
     */
    public function getFile_ID()
    {
        return $this->File_ID;
    }
    /**
     * Set File_ID value
     * @param string $file_ID
     * @return \StructType\Financials_Attachment_WWS_DataType
     */
    public function setFile_ID($file_ID = null)
    {
        // validation for constraint: string
        if (!is_null($file_ID) && !is_string($file_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($file_ID, true), gettype($file_ID)), __LINE__);
        }
        $this->File_ID = $file_ID;
        return $this;
    }
    /**
     * Get External_Sourceable_ID value
     * @return string|null
     */
    public function getExternal_Sourceable_ID()
    {
        return $this->External_Sourceable_ID;
    }
    /**
     * Set External_Sourceable_ID value
     * @param string $external_Sourceable_ID
     * @return \StructType\Financials_Attachment_WWS_DataType
     */
    public function setExternal_Sourceable_ID($external_Sourceable_ID = null)
    {
        // validation for constraint: string
        if (!is_null($external_Sourceable_ID) && !is_string($external_Sourceable_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Sourceable_ID, true), gettype($external_Sourceable_ID)), __LINE__);
        }
        $this->External_Sourceable_ID = $external_Sourceable_ID;
        return $this;
    }
    /**
     * Get File_Content value
     * @return string|null
     */
    public function getFile_Content()
    {
        return $this->File_Content;
    }
    /**
     * Set File_Content value
     * @param string $file_Content
     * @return \StructType\Financials_Attachment_WWS_DataType
     */
    public function setFile_Content($file_Content = null)
    {
        // validation for constraint: string
        if (!is_null($file_Content) && !is_string($file_Content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($file_Content, true), gettype($file_Content)), __LINE__);
        }
        $this->File_Content = $file_Content;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Financials_Attachment_WWS_DataType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get Content_Type value
     * @return string|null
     */
    public function getContent_Type()
    {
        return $this->Content_Type;
    }
    /**
     * Set Content_Type value
     * @param string $content_Type
     * @return \StructType\Financials_Attachment_WWS_DataType
     */
    public function setContent_Type($content_Type = null)
    {
        // validation for constraint: string
        if (!is_null($content_Type) && !is_string($content_Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($content_Type, true), gettype($content_Type)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($content_Type) && mb_strlen($content_Type) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($content_Type)), __LINE__);
        }
        $this->Content_Type = $content_Type;
        return $this;
    }
    /**
     * Get Filename value
     * @return string|null
     */
    public function getFilename()
    {
        return $this->Filename;
    }
    /**
     * Set Filename value
     * @param string $filename
     * @return \StructType\Financials_Attachment_WWS_DataType
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filename, true), gettype($filename)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($filename) && mb_strlen($filename) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($filename)), __LINE__);
        }
        $this->Filename = $filename;
        return $this;
    }
    /**
     * Get Encoding value
     * @return string|null
     */
    public function getEncoding()
    {
        return $this->Encoding;
    }
    /**
     * Set Encoding value
     * @param string $encoding
     * @return \StructType\Financials_Attachment_WWS_DataType
     */
    public function setEncoding($encoding = null)
    {
        // validation for constraint: string
        if (!is_null($encoding) && !is_string($encoding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encoding, true), gettype($encoding)), __LINE__);
        }
        $this->Encoding = $encoding;
        return $this;
    }
    /**
     * Get Compressed value
     * @return bool|null
     */
    public function getCompressed()
    {
        return $this->Compressed;
    }
    /**
     * Set Compressed value
     * @param bool $compressed
     * @return \StructType\Financials_Attachment_WWS_DataType
     */
    public function setCompressed($compressed = null)
    {
        // validation for constraint: boolean
        if (!is_null($compressed) && !is_bool($compressed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($compressed, true), gettype($compressed)), __LINE__);
        }
        $this->Compressed = $compressed;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Financials_Attachment_WWS_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
