<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Travel_Booking_File_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Travel Booking File Request Criteria. Consists of and Start and End date. Travel Files loaded between Start and End Date are returned.
 * @subpackage Structs
 */
class Travel_Booking_File_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Travel_Booking_Record_Load_Date___Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Travel Booking Record Load Date - Start Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Travel_Booking_Record_Load_Date___Start_Date;
    /**
     * The Travel_Booking_Record_Load_Date___End_Date
     * Meta information extracted from the WSDL
     * - documentation: Travel Booking Record Load Date - End Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Travel_Booking_Record_Load_Date___End_Date;
    /**
     * Constructor method for Travel_Booking_File_Request_CriteriaType
     * @uses Travel_Booking_File_Request_CriteriaType::setTravel_Booking_Record_Load_Date___Start_Date()
     * @uses Travel_Booking_File_Request_CriteriaType::setTravel_Booking_Record_Load_Date___End_Date()
     * @param string $travel_Booking_Record_Load_Date___Start_Date
     * @param string $travel_Booking_Record_Load_Date___End_Date
     */
    public function __construct($travel_Booking_Record_Load_Date___Start_Date = null, $travel_Booking_Record_Load_Date___End_Date = null)
    {
        $this
            ->setTravel_Booking_Record_Load_Date___Start_Date($travel_Booking_Record_Load_Date___Start_Date)
            ->setTravel_Booking_Record_Load_Date___End_Date($travel_Booking_Record_Load_Date___End_Date);
    }
    /**
     * Get Travel_Booking_Record_Load_Date___Start_Date value
     * @return string|null
     */
    public function getTravel_Booking_Record_Load_Date___Start_Date()
    {
        return $this->{'Travel_Booking_Record_Load_Date_-_Start_Date'};
    }
    /**
     * Set Travel_Booking_Record_Load_Date___Start_Date value
     * @param string $travel_Booking_Record_Load_Date___Start_Date
     * @return \StructType\Travel_Booking_File_Request_CriteriaType
     */
    public function setTravel_Booking_Record_Load_Date___Start_Date($travel_Booking_Record_Load_Date___Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($travel_Booking_Record_Load_Date___Start_Date) && !is_string($travel_Booking_Record_Load_Date___Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travel_Booking_Record_Load_Date___Start_Date, true), gettype($travel_Booking_Record_Load_Date___Start_Date)), __LINE__);
        }
        $this->Travel_Booking_Record_Load_Date___Start_Date = $this->{'Travel_Booking_Record_Load_Date_-_Start_Date'} = $travel_Booking_Record_Load_Date___Start_Date;
        return $this;
    }
    /**
     * Get Travel_Booking_Record_Load_Date___End_Date value
     * @return string|null
     */
    public function getTravel_Booking_Record_Load_Date___End_Date()
    {
        return $this->{'Travel_Booking_Record_Load_Date_-_End_Date'};
    }
    /**
     * Set Travel_Booking_Record_Load_Date___End_Date value
     * @param string $travel_Booking_Record_Load_Date___End_Date
     * @return \StructType\Travel_Booking_File_Request_CriteriaType
     */
    public function setTravel_Booking_Record_Load_Date___End_Date($travel_Booking_Record_Load_Date___End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($travel_Booking_Record_Load_Date___End_Date) && !is_string($travel_Booking_Record_Load_Date___End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travel_Booking_Record_Load_Date___End_Date, true), gettype($travel_Booking_Record_Load_Date___End_Date)), __LINE__);
        }
        $this->Travel_Booking_Record_Load_Date___End_Date = $this->{'Travel_Booking_Record_Load_Date_-_End_Date'} = $travel_Booking_Record_Load_Date___End_Date;
        return $this;
    }
}
