<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request_for_Quote_Award_Data_InboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element used to capture information to create a RFQ Award document. It contains Purchase Order or Supplier Contract Defaults, RFQ Award Lines and Line Split information.
 * @subpackage Structs
 */
class Request_for_Quote_Award_Data_InboundType extends AbstractStructBase
{
    /**
     * The Request_for_Quote_Award_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference to RFQ Award Document
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Request_for_Quote_Award_ID;
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Submit
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company used to record RFQ Award.
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Request_for_Quote_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to RFQ against which the award is created.
     * @var \StructType\Request_for_QuoteObjectType
     */
    public $Request_for_Quote_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier on RFQ Award
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The Award_Date
     * Meta information extracted from the WSDL
     * - documentation: Award Date
     * - maxOccurs: 1
     * @var string
     */
    public $Award_Date;
    /**
     * The Award_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: Award Reason for Request for Quote Award.
     * - minOccurs: 0
     * @var \StructType\Procurement_Award_ReasonObjectType
     */
    public $Award_Reason_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency on RFQ Award
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The RFQ_Award_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: RFQ Award Type
     * @var \StructType\Request_for_Quote_Award_TypeObjectType
     */
    public $RFQ_Award_Type_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Award Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Auto_submit_Award_Outcome_for_Approval
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether to submit the RFQ Award outcome document for approval
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Auto_submit_Award_Outcome_for_Approval;
    /**
     * The RFQ_Award_PO_Defaults_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RFQ_Award_PO_Defaults_Data_InboundType
     */
    public $RFQ_Award_PO_Defaults_Data;
    /**
     * The RFQ_Award_Contract_Defaults_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RFQ_Award_Contract_Defaults_Data_InboundType
     */
    public $RFQ_Award_Contract_Defaults_Data;
    /**
     * The Business_Document_Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_Attachment_with_External_Option_DataType[]
     */
    public $Business_Document_Attachment_Data;
    /**
     * The Request_for_Quote_Award_Line_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Request_for_Quote_Award_Line_Data_InboundType[]
     */
    public $Request_for_Quote_Award_Line_Data;
    /**
     * Constructor method for Request_for_Quote_Award_Data_InboundType
     * @uses Request_for_Quote_Award_Data_InboundType::setRequest_for_Quote_Award_ID()
     * @uses Request_for_Quote_Award_Data_InboundType::setSubmit()
     * @uses Request_for_Quote_Award_Data_InboundType::setCompany_Reference()
     * @uses Request_for_Quote_Award_Data_InboundType::setRequest_for_Quote_Reference()
     * @uses Request_for_Quote_Award_Data_InboundType::setSupplier_Reference()
     * @uses Request_for_Quote_Award_Data_InboundType::setAward_Date()
     * @uses Request_for_Quote_Award_Data_InboundType::setAward_Reason_Reference()
     * @uses Request_for_Quote_Award_Data_InboundType::setCurrency_Reference()
     * @uses Request_for_Quote_Award_Data_InboundType::setRFQ_Award_Type_Reference()
     * @uses Request_for_Quote_Award_Data_InboundType::setMemo()
     * @uses Request_for_Quote_Award_Data_InboundType::setAuto_submit_Award_Outcome_for_Approval()
     * @uses Request_for_Quote_Award_Data_InboundType::setRFQ_Award_PO_Defaults_Data()
     * @uses Request_for_Quote_Award_Data_InboundType::setRFQ_Award_Contract_Defaults_Data()
     * @uses Request_for_Quote_Award_Data_InboundType::setBusiness_Document_Attachment_Data()
     * @uses Request_for_Quote_Award_Data_InboundType::setRequest_for_Quote_Award_Line_Data()
     * @param string $request_for_Quote_Award_ID
     * @param bool $submit
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Request_for_QuoteObjectType $request_for_Quote_Reference
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param string $award_Date
     * @param \StructType\Procurement_Award_ReasonObjectType $award_Reason_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Request_for_Quote_Award_TypeObjectType $rFQ_Award_Type_Reference
     * @param string $memo
     * @param bool $auto_submit_Award_Outcome_for_Approval
     * @param \StructType\RFQ_Award_PO_Defaults_Data_InboundType $rFQ_Award_PO_Defaults_Data
     * @param \StructType\RFQ_Award_Contract_Defaults_Data_InboundType $rFQ_Award_Contract_Defaults_Data
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType[] $business_Document_Attachment_Data
     * @param \StructType\Request_for_Quote_Award_Line_Data_InboundType[] $request_for_Quote_Award_Line_Data
     */
    public function __construct($request_for_Quote_Award_ID = null, $submit = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\Request_for_QuoteObjectType $request_for_Quote_Reference = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null, $award_Date = null, \StructType\Procurement_Award_ReasonObjectType $award_Reason_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Request_for_Quote_Award_TypeObjectType $rFQ_Award_Type_Reference = null, $memo = null, $auto_submit_Award_Outcome_for_Approval = null, \StructType\RFQ_Award_PO_Defaults_Data_InboundType $rFQ_Award_PO_Defaults_Data = null, \StructType\RFQ_Award_Contract_Defaults_Data_InboundType $rFQ_Award_Contract_Defaults_Data = null, array $business_Document_Attachment_Data = array(), array $request_for_Quote_Award_Line_Data = array())
    {
        $this
            ->setRequest_for_Quote_Award_ID($request_for_Quote_Award_ID)
            ->setSubmit($submit)
            ->setCompany_Reference($company_Reference)
            ->setRequest_for_Quote_Reference($request_for_Quote_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setAward_Date($award_Date)
            ->setAward_Reason_Reference($award_Reason_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setRFQ_Award_Type_Reference($rFQ_Award_Type_Reference)
            ->setMemo($memo)
            ->setAuto_submit_Award_Outcome_for_Approval($auto_submit_Award_Outcome_for_Approval)
            ->setRFQ_Award_PO_Defaults_Data($rFQ_Award_PO_Defaults_Data)
            ->setRFQ_Award_Contract_Defaults_Data($rFQ_Award_Contract_Defaults_Data)
            ->setBusiness_Document_Attachment_Data($business_Document_Attachment_Data)
            ->setRequest_for_Quote_Award_Line_Data($request_for_Quote_Award_Line_Data);
    }
    /**
     * Get Request_for_Quote_Award_ID value
     * @return string|null
     */
    public function getRequest_for_Quote_Award_ID()
    {
        return $this->Request_for_Quote_Award_ID;
    }
    /**
     * Set Request_for_Quote_Award_ID value
     * @param string $request_for_Quote_Award_ID
     * @return \StructType\Request_for_Quote_Award_Data_InboundType
     */
    public function setRequest_for_Quote_Award_ID($request_for_Quote_Award_ID = null)
    {
        // validation for constraint: string
        if (!is_null($request_for_Quote_Award_ID) && !is_string($request_for_Quote_Award_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($request_for_Quote_Award_ID, true), gettype($request_for_Quote_Award_ID)), __LINE__);
        }
        $this->Request_for_Quote_Award_ID = $request_for_Quote_Award_ID;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Request_for_Quote_Award_Data_InboundType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Request_for_Quote_Award_Data_InboundType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Request_for_Quote_Reference value
     * @return \StructType\Request_for_QuoteObjectType|null
     */
    public function getRequest_for_Quote_Reference()
    {
        return $this->Request_for_Quote_Reference;
    }
    /**
     * Set Request_for_Quote_Reference value
     * @param \StructType\Request_for_QuoteObjectType $request_for_Quote_Reference
     * @return \StructType\Request_for_Quote_Award_Data_InboundType
     */
    public function setRequest_for_Quote_Reference(\StructType\Request_for_QuoteObjectType $request_for_Quote_Reference = null)
    {
        $this->Request_for_Quote_Reference = $request_for_Quote_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\Request_for_Quote_Award_Data_InboundType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Award_Date value
     * @return string|null
     */
    public function getAward_Date()
    {
        return $this->Award_Date;
    }
    /**
     * Set Award_Date value
     * @param string $award_Date
     * @return \StructType\Request_for_Quote_Award_Data_InboundType
     */
    public function setAward_Date($award_Date = null)
    {
        // validation for constraint: string
        if (!is_null($award_Date) && !is_string($award_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($award_Date, true), gettype($award_Date)), __LINE__);
        }
        $this->Award_Date = $award_Date;
        return $this;
    }
    /**
     * Get Award_Reason_Reference value
     * @return \StructType\Procurement_Award_ReasonObjectType|null
     */
    public function getAward_Reason_Reference()
    {
        return $this->Award_Reason_Reference;
    }
    /**
     * Set Award_Reason_Reference value
     * @param \StructType\Procurement_Award_ReasonObjectType $award_Reason_Reference
     * @return \StructType\Request_for_Quote_Award_Data_InboundType
     */
    public function setAward_Reason_Reference(\StructType\Procurement_Award_ReasonObjectType $award_Reason_Reference = null)
    {
        $this->Award_Reason_Reference = $award_Reason_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Request_for_Quote_Award_Data_InboundType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get RFQ_Award_Type_Reference value
     * @return \StructType\Request_for_Quote_Award_TypeObjectType|null
     */
    public function getRFQ_Award_Type_Reference()
    {
        return $this->RFQ_Award_Type_Reference;
    }
    /**
     * Set RFQ_Award_Type_Reference value
     * @param \StructType\Request_for_Quote_Award_TypeObjectType $rFQ_Award_Type_Reference
     * @return \StructType\Request_for_Quote_Award_Data_InboundType
     */
    public function setRFQ_Award_Type_Reference(\StructType\Request_for_Quote_Award_TypeObjectType $rFQ_Award_Type_Reference = null)
    {
        $this->RFQ_Award_Type_Reference = $rFQ_Award_Type_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Request_for_Quote_Award_Data_InboundType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Auto_submit_Award_Outcome_for_Approval value
     * @return bool|null
     */
    public function getAuto_submit_Award_Outcome_for_Approval()
    {
        return $this->{'Auto-submit_Award_Outcome_for_Approval'};
    }
    /**
     * Set Auto_submit_Award_Outcome_for_Approval value
     * @param bool $auto_submit_Award_Outcome_for_Approval
     * @return \StructType\Request_for_Quote_Award_Data_InboundType
     */
    public function setAuto_submit_Award_Outcome_for_Approval($auto_submit_Award_Outcome_for_Approval = null)
    {
        // validation for constraint: boolean
        if (!is_null($auto_submit_Award_Outcome_for_Approval) && !is_bool($auto_submit_Award_Outcome_for_Approval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($auto_submit_Award_Outcome_for_Approval, true), gettype($auto_submit_Award_Outcome_for_Approval)), __LINE__);
        }
        $this->Auto_submit_Award_Outcome_for_Approval = $this->{'Auto-submit_Award_Outcome_for_Approval'} = $auto_submit_Award_Outcome_for_Approval;
        return $this;
    }
    /**
     * Get RFQ_Award_PO_Defaults_Data value
     * @return \StructType\RFQ_Award_PO_Defaults_Data_InboundType|null
     */
    public function getRFQ_Award_PO_Defaults_Data()
    {
        return $this->RFQ_Award_PO_Defaults_Data;
    }
    /**
     * Set RFQ_Award_PO_Defaults_Data value
     * @param \StructType\RFQ_Award_PO_Defaults_Data_InboundType $rFQ_Award_PO_Defaults_Data
     * @return \StructType\Request_for_Quote_Award_Data_InboundType
     */
    public function setRFQ_Award_PO_Defaults_Data(\StructType\RFQ_Award_PO_Defaults_Data_InboundType $rFQ_Award_PO_Defaults_Data = null)
    {
        $this->RFQ_Award_PO_Defaults_Data = $rFQ_Award_PO_Defaults_Data;
        return $this;
    }
    /**
     * Get RFQ_Award_Contract_Defaults_Data value
     * @return \StructType\RFQ_Award_Contract_Defaults_Data_InboundType|null
     */
    public function getRFQ_Award_Contract_Defaults_Data()
    {
        return $this->RFQ_Award_Contract_Defaults_Data;
    }
    /**
     * Set RFQ_Award_Contract_Defaults_Data value
     * @param \StructType\RFQ_Award_Contract_Defaults_Data_InboundType $rFQ_Award_Contract_Defaults_Data
     * @return \StructType\Request_for_Quote_Award_Data_InboundType
     */
    public function setRFQ_Award_Contract_Defaults_Data(\StructType\RFQ_Award_Contract_Defaults_Data_InboundType $rFQ_Award_Contract_Defaults_Data = null)
    {
        $this->RFQ_Award_Contract_Defaults_Data = $rFQ_Award_Contract_Defaults_Data;
        return $this;
    }
    /**
     * Get Business_Document_Attachment_Data value
     * @return \StructType\Business_Document_Attachment_with_External_Option_DataType[]|null
     */
    public function getBusiness_Document_Attachment_Data()
    {
        return $this->Business_Document_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Document_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Document_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Document_Attachment_DataForArrayConstraintsFromSetBusiness_Document_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Award_Data_InboundTypeBusiness_Document_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Award_Data_InboundTypeBusiness_Document_Attachment_DataItem instanceof \StructType\Business_Document_Attachment_with_External_Option_DataType) {
                $invalidValues[] = is_object($request_for_Quote_Award_Data_InboundTypeBusiness_Document_Attachment_DataItem) ? get_class($request_for_Quote_Award_Data_InboundTypeBusiness_Document_Attachment_DataItem) : sprintf('%s(%s)', gettype($request_for_Quote_Award_Data_InboundTypeBusiness_Document_Attachment_DataItem), var_export($request_for_Quote_Award_Data_InboundTypeBusiness_Document_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Document_Attachment_Data property can only contain items of type \StructType\Business_Document_Attachment_with_External_Option_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Document_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType[] $business_Document_Attachment_Data
     * @return \StructType\Request_for_Quote_Award_Data_InboundType
     */
    public function setBusiness_Document_Attachment_Data(array $business_Document_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Document_Attachment_DataArrayErrorMessage = self::validateBusiness_Document_Attachment_DataForArrayConstraintsFromSetBusiness_Document_Attachment_Data($business_Document_Attachment_Data))) {
            throw new \InvalidArgumentException($business_Document_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Business_Document_Attachment_Data = $business_Document_Attachment_Data;
        return $this;
    }
    /**
     * Add item to Business_Document_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType $item
     * @return \StructType\Request_for_Quote_Award_Data_InboundType
     */
    public function addToBusiness_Document_Attachment_Data(\StructType\Business_Document_Attachment_with_External_Option_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_Attachment_with_External_Option_DataType) {
            throw new \InvalidArgumentException(sprintf('The Business_Document_Attachment_Data property can only contain items of type \StructType\Business_Document_Attachment_with_External_Option_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Document_Attachment_Data[] = $item;
        return $this;
    }
    /**
     * Get Request_for_Quote_Award_Line_Data value
     * @return \StructType\Request_for_Quote_Award_Line_Data_InboundType[]|null
     */
    public function getRequest_for_Quote_Award_Line_Data()
    {
        return $this->Request_for_Quote_Award_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRequest_for_Quote_Award_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequest_for_Quote_Award_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequest_for_Quote_Award_Line_DataForArrayConstraintsFromSetRequest_for_Quote_Award_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Award_Data_InboundTypeRequest_for_Quote_Award_Line_DataItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Award_Data_InboundTypeRequest_for_Quote_Award_Line_DataItem instanceof \StructType\Request_for_Quote_Award_Line_Data_InboundType) {
                $invalidValues[] = is_object($request_for_Quote_Award_Data_InboundTypeRequest_for_Quote_Award_Line_DataItem) ? get_class($request_for_Quote_Award_Data_InboundTypeRequest_for_Quote_Award_Line_DataItem) : sprintf('%s(%s)', gettype($request_for_Quote_Award_Data_InboundTypeRequest_for_Quote_Award_Line_DataItem), var_export($request_for_Quote_Award_Data_InboundTypeRequest_for_Quote_Award_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Request_for_Quote_Award_Line_Data property can only contain items of type \StructType\Request_for_Quote_Award_Line_Data_InboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Request_for_Quote_Award_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Award_Line_Data_InboundType[] $request_for_Quote_Award_Line_Data
     * @return \StructType\Request_for_Quote_Award_Data_InboundType
     */
    public function setRequest_for_Quote_Award_Line_Data(array $request_for_Quote_Award_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($request_for_Quote_Award_Line_DataArrayErrorMessage = self::validateRequest_for_Quote_Award_Line_DataForArrayConstraintsFromSetRequest_for_Quote_Award_Line_Data($request_for_Quote_Award_Line_Data))) {
            throw new \InvalidArgumentException($request_for_Quote_Award_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Request_for_Quote_Award_Line_Data = $request_for_Quote_Award_Line_Data;
        return $this;
    }
    /**
     * Add item to Request_for_Quote_Award_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Award_Line_Data_InboundType $item
     * @return \StructType\Request_for_Quote_Award_Data_InboundType
     */
    public function addToRequest_for_Quote_Award_Line_Data(\StructType\Request_for_Quote_Award_Line_Data_InboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Request_for_Quote_Award_Line_Data_InboundType) {
            throw new \InvalidArgumentException(sprintf('The Request_for_Quote_Award_Line_Data property can only contain items of type \StructType\Request_for_Quote_Award_Line_Data_InboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Request_for_Quote_Award_Line_Data[] = $item;
        return $this;
    }
}
